plugins {
    id("com.android.library")
    id("org.jetbrains.kotlin.android")
    id("maven-publish")
}

android {
    namespace = "com.example.mylibrary"
    compileSdk = 34

    defaultConfig {
        minSdk = 24

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        consumerProguardFiles("consumer-rules.pro")
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }
    kotlinOptions {
        jvmTarget = "1.8"
    }
}

dependencies {

    implementation("androidx.core:core-ktx:1.10.1")
    implementation("androidx.appcompat:appcompat:1.6.1")
    implementation("com.google.android.material:material:1.9.0")
    testImplementation("junit:junit:4.13.2")
    androidTestImplementation("androidx.test.ext:junit:1.1.5")
    androidTestImplementation("androidx.test.espresso:espresso-core:3.5.1")
}
afterEvaluate {

    publishing {
        publications {
            create<MavenPublication>("release") {
                from(components["release"])

                groupId = "com.gingersoft.connect"
                artifactId = "Connect"
                version = "1.0.0"
                // 添加 POM 配置
//                pom {
//                    name.set("GingerSoftConnect")
//                    description.set("用於局域網多設備發現、連接、通信的庫")
//                    url.set("https://your.library.url")
//
//                    licenses {
//                        license {
//                            name.set("The Apache License, Version 2.0")
//                            url.set("http://www.apache.org/licenses/LICENSE-2.0.txt")
//                        }
//                    }
//                    developers {
//                        developer {
//                            id.set("developerId")
//                            name.set("Developer Name")
//                            email.set("1239658231@qq.com")
//                        }
//                    }
//                    scm {
//                        connection.set("scm:git:git://your.repository.url.git")
//                        developerConnection.set("scm:git:ssh://your.repository.url.git")
//                        url.set("https://your.repository.url")
//                    }
//                }
            }
        }

        repositories {
            maven {
                url = uri("https://your.remote.repo.url")
                credentials {
                    username = project.findProperty("mavenUsername") as String? ?: "defaultUsername"
                    password = project.findProperty("mavenPassword") as String? ?: "defaultPassword"
                }
            }
        }
    }
}
