package com.gingersoft.connect.bean

import com.gingersoft.connect.utils.GingerSoftConnect
import com.gingersoft.connect.utils.MyWebSocketClient
import java.util.concurrent.atomic.AtomicInteger

class MessageBuilder(
    private val connect: GingerSoftConnect,
    private val webSocketClient: MyWebSocketClient
) {

    companion object {
        private val msgCode = AtomicInteger(0)
        const val ERROR_CODE_SEND_TIMEOUT = 100
        const val ERROR_CODE_NOT_CONNECT = 101
        const val ERROR_CODE_CONNECT_TIMEOUT = 102

    }

    fun initSendData(action: Action, sendData: SendMsgType): MessageSender {
        val currentMsgCode = msgCode.incrementAndGet()
        val msg = MessageBean(currentMsgCode, action.toString(), sendData)
        return MessageSender(connect, webSocketClient, msg)
    }

}