package com.example.demo

import android.app.Activity
import android.os.Bundle
import android.util.Log
import android.widget.TextView
import com.example.gingersoft_connect.R
import com.gingersoft.connect.SendCallback
import com.gingersoft.connect.bean.Action
import com.gingersoft.connect.bean.MessageBuilder
import com.gingersoft.connect.bean.MessageSender
import com.gingersoft.connect.bean.OrderInfoBean
import com.gingersoft.connect.utils.GingerSoftConnect

class MainActivity : Activity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        var msgSender: MessageBuilder? = null
        var connect: GingerSoftConnect? = null
        val tvConnect = findViewById<TextView>(R.id.tv_connect)
        val tvDisconnect = findViewById<TextView>(R.id.tv_disconnect)
        val tvSendMsg = findViewById<TextView>(R.id.tv_send_msg)
        val tvSendValue = findViewById<TextView>(R.id.tv_send_value)

        tvConnect.setOnClickListener {
            tvConnect.isClickable = false
            connect = GingerSoftConnect()
            msgSender = connect!!.connect(
                "192.168.1.151",
                12581,
                object : GingerSoftConnect.SocketStateListener {
                    override fun onOpen() {
                        super.onOpen()
                        runOnUiThread {
                            tvConnect.text = "已連接"
                            tvConnect.isClickable = true
                        }
                    }

                    override fun onClose(code: Int, reason: String?, remote: Boolean) {
                        super.onClose(code, reason, remote)
                        runOnUiThread {
                            tvConnect.text = "已斷開：$code,$reason"
                            tvConnect.isClickable = true
                        }
                    }

                    override fun onError(ex: Exception?) {
                        super.onError(ex)
                        runOnUiThread {
                            tvConnect.isClickable = true
                            tvConnect.text = "發生錯誤：${ex?.message}"
                        }
                    }

                })
        }

        tvDisconnect.setOnClickListener {
            connect?.disconnect()
        }

        tvSendMsg.setOnClickListener {
            msgSender?.initSendData(Action.KitchenInfo, OrderInfoBean())
                ?.asyncSend(object : SendCallback {
                    override fun callback(status: Boolean, errorCode: Int) {
                        runOnUiThread {
                            tvSendValue.text = if (status) "發送成功" else when (errorCode) {
                                MessageBuilder.ERROR_CODE_SEND_TIMEOUT -> "發送消息超時"
                                MessageBuilder.ERROR_CODE_NOT_CONNECT -> "未連接到服務器"
                                MessageBuilder.ERROR_CODE_CONNECT_TIMEOUT -> "連接服務器超時"
                                else -> "發生錯誤：$errorCode"
                            }
                        }
                    }
                })
        }
    }
}