package com.gingersoft.connect.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GsonUtils {

    private static volatile Gson gson;

    public static Gson getGson() {
        if (gson == null) {
            synchronized (GsonUtils.class) {
                if (gson == null) {
                    gson = new Gson();
                }
            }
        }
        return gson;
    }

    public static void init(Gson gson) {
        GsonUtils.gson = gson;
    }

    private GsonUtils() {
    }

    /**
     * 轉成json
     *
     * @param object
     * @return
     */
    public static String GsonString(Object object) {
        String gsonString = null;
        try {
            gsonString = getGson().toJson(object);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return gsonString;
    }

    /**
     * 轉成bean
     *
     * @param gsonString
     * @param cls
     * @return
     */
    public static <T> T GsonToBean(String gsonString, Class<T> cls) {
        T t = null;
        try {
            t = getGson().fromJson(gsonString, cls);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    /**
     * 轉成bean
     *
     * @param gsonString
     * @param cls
     * @return
     */
    public static <T> T GsonToBean(Object gsonString, Class<T> cls) {
        return GsonToBean(GsonString(gsonString), cls);
    }

    /**
     * json字符串轉成list
     *
     * @param cls
     * @return
     */
    public static <T> ArrayList<T> jsonToList(Object object, Class<T> cls) {
        return jsonToList(GsonString(object), cls);
    }

    /**
     * json字符串轉成list
     *
     * @param cls
     * @return
     */
    public static <T> ArrayList<T> jsonToList(String json, Class<T> cls) {
        ArrayList<T> mList = new ArrayList<>();
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            JsonArray array = new JsonParser().parse(json).getAsJsonArray();
            for (final JsonElement elem : array) {
                mList.add(getGson().fromJson(elem, cls));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return mList;
    }

    /**
     * 轉成list中有map的
     *
     * @param gsonString
     * @return
     */
    public static <T> List<Map<String, T>> GsonToListMaps(String gsonString) {
        List<Map<String, T>> list = null;
        list = getGson().fromJson(gsonString,
                new TypeToken<List<Map<String, T>>>() {
                }.getType());
        return list;
    }

    /**
     * 轉成map的
     *
     * @param gsonString
     * @return
     */
    public static <T> Map<String, T> GsonToMaps(String gsonString) {
        Map<String, T> map = null;
        map = getGson().fromJson(gsonString, new TypeToken<Map<String, T>>() {
        }.getType());
        return map;
    }
}
