package com.gingersoft.connect.bean

import com.gingersoft.connect.utils.GingerSoftConnect
import com.gingersoft.connect.utils.GsonUtils
import com.gingersoft.connect.utils.MyWebSocketClient
import java.util.concurrent.atomic.AtomicInteger

class MessageBuilder(
    private val connect: GingerSoftConnect,
    private val webSocketClient: MyWebSocketClient
) {

    companion object {
        private val msgCode = AtomicInteger(0)
        const val ERROR_CODE_SEND_TIMEOUT = 100
        const val ERROR_CODE_NOT_CONNECT = 101
        const val ERROR_CODE_CONNECT_TIMEOUT = 102
        const val ERROR_CODE_ORDER_INFO_INCORRECT = 103// 訂單信息有誤
        const val ERROR_CODE_DATA_NULL = 104// 获取到的数据为null
        const val ERROR_CODE_ANALYSIS_FAILED = 105// 數據解析失敗
    }

    fun initSendData(action: Action, sendData: SendMsgType): MessageSender {
        val currentMsgCode = msgCode.incrementAndGet()
        val msg = MessageBean(currentMsgCode, action.toString(), GsonUtils.GsonString(sendData))
        return MessageSender(connect, webSocketClient, msg)
    }

}