package com.gingersoft.connect.utils

import com.gingersoft.connect.bean.MessageBean
import com.gingersoft.connect.bean.SocketCallbackBean

/**
 * 消息中轉，由具體的類去處理具體的事
 */
object MsgParser {

    val parserMap by lazy { mutableMapOf<String, MsgProcess>() }

    fun process(msgBean: MessageBean<*>?): SocketCallbackBean? {
        return if (msgBean != null) {
            val result = parserMap[msgBean.action.toString()]?.sendMsg()
            if (result != null) {
                SocketCallbackBean(
                    result.success,
                    200,
                    msgBean.code.toString(),
                    result.errorMsg,
                    result.data
                )
            } else {
                return null
            }
        } else {
            null
        }
    }
}