package com.gingersoft.connect.utils

import android.content.Context
import com.gingersoft.connect.bean.Action
import com.gingersoft.connect.bean.GetFoodInfoProcess
import com.gingersoft.connect.bean.GetSoldOutInfoProcess
import java.net.InetSocketAddress

object SoldOut {

    /**
     * 接收數據的服務
     */
    private var mWebSocketServer: MyWebSocketServer? = null
    private var nsdUtils: NSDUtils? = null

    fun init(context: Context) {
        // 註冊NSD，讓後面開啟的KDS能主動找到POS設備，然後從POS設備拿食品信息
        nsdUtils = NSDUtils()
        nsdUtils?.registerKDS(context)
        // 開啟服務，接收KDS發來的消息
        mWebSocketServer = MyWebSocketServer(InetSocketAddress(12581))
        mWebSocketServer?.isReuseAddr = true // 設置地址可複用，避免APP被用戶強制殺掉後，再次打開報錯Address already in use
        mWebSocketServer?.start()
    }

    fun initFoodInfoTransmitter(process: GetFoodInfoProcess) {
        MsgParser.parserMap[Action.FoodInfo.toString()] = process
    }

    fun initSoldOutInfoTransmitter(process: GetSoldOutInfoProcess) {
        MsgParser.parserMap[Action.SoldOutInfo.toString()] = process
    }

    fun stopServer() {
        mWebSocketServer?.stop()
    }
}