//package com.gingersoft.connect.utils
//
//import android.content.Context
//import android.net.wifi.WifiManager
//import android.util.Log
//import java.io.IOException
//import java.net.InetAddress
//import javax.jmdns.JmDNS
//import javax.jmdns.ServiceEvent
//import javax.jmdns.ServiceInfo
//import javax.jmdns.ServiceListener
//
//object DeviceDiscovery {
//
//    var jmdns: JmDNS? = null
//    fun discoverDevices(context: Context, port: Int, callback: (String, Int) -> Unit) {
//        try {
//            val wifiManager = context.getSystemService(Context.WIFI_SERVICE) as WifiManager
//            val multicastLock = wifiManager.createMulticastLock("myMulticastLock")
//            multicastLock.setReferenceCounted(true)
//            multicastLock.acquire() // 開啟多播鎖可以快速接收消息，但是會增加耗電量
//            val address = getLocalIpAddress(context)
//            if (address != null) {
//                jmdns = JmDNS.create(address)
//                val serviceInfo =
//                    ServiceInfo.create("_ws._tcp.local.", "gingersoft", port, "path=index.html")
//                jmdns?.registerService(serviceInfo)
//                jmdns?.addServiceListener("_ws._tcp.local.", object : ServiceListener {
//                    override fun serviceAdded(event: ServiceEvent) {
//                        Log.e("eeeaaa", "Service added:${event.info}}")
//                    }
//
//                    override fun serviceRemoved(event: ServiceEvent) {
//                        Log.e("eeeaaa", "Service removed: ${event.info}")
//                    }
//
//                    override fun serviceResolved(event: ServiceEvent) {
//                        val hostAddress = event.info.hostAddresses[0]
//                        val port = event.info.port
//                        Log.e("eeeaaa", "serviceResolved: ${event.info}---${hostAddress}---${address.hostAddress}")
//                        if (event.info.name.contains("gingersoft") && hostAddress != null && hostAddress != address.hostAddress) {
//                            Log.e("eeeaaa", "Service resolved: ${event.info} at $hostAddress:$port")
//                            callback(hostAddress, port)
//                        }
//                        // 超過多久搜索不到，關閉多播鎖
////                         multicastLock.release()
//                    }
//                })
//            } else {
//                Log.e("eeeaaa", "Failed to get local IP address")
//            }
//        } catch (e: IOException) {
//            e.printStackTrace()
//        }
//    }
//
//    private fun getLocalIpAddress(context: Context): InetAddress? {
//        try {
//            val wifiManager = context.getSystemService(Context.WIFI_SERVICE) as WifiManager
//            val wifiInfo = wifiManager.connectionInfo
//            val ipAddress = wifiInfo.ipAddress
//            val ipByteArray = byteArrayOf(
//                (ipAddress and 0xff).toByte(),
//                (ipAddress shr 8 and 0xff).toByte(),
//                (ipAddress shr 16 and 0xff).toByte(),
//                (ipAddress shr 24 and 0xff).toByte()
//            )
//            return InetAddress.getByAddress(ipByteArray)
//        } catch (e: Exception) {
//            e.printStackTrace()
//        }
//        return null
//    }
//
//
//    fun stopService() {
//        if (jmdns != null) {
//            jmdns!!.unregisterAllServices()
//            try {
//                jmdns!!.close()
//            } catch (e: IOException) {
//                e.printStackTrace()
//            }
//        }
//    }
//}