package com.example.demo

import android.app.Activity
import android.os.Bundle
import android.widget.TextView
import com.example.gingersoft_connect.R
import com.gingersoft.connect.SendCallback
import com.gingersoft.connect.bean.Action
import com.gingersoft.connect.bean.FoodInfoBean
import com.gingersoft.connect.bean.MessageBuilder
import com.gingersoft.connect.bean.OrderInfoBean
import com.gingersoft.connect.utils.GingerSoftConnect

class MainActivity : Activity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        var msgSender: MessageBuilder? = null
        var connect: GingerSoftConnect? = null
        val tvConnect = findViewById<TextView>(R.id.tv_connect)
        val tvDisconnect = findViewById<TextView>(R.id.tv_disconnect)
        val tvSendMsg = findViewById<TextView>(R.id.tv_send_msg)
        val tvSendValue = findViewById<TextView>(R.id.tv_send_value)

        tvConnect.setOnClickListener {
            tvConnect.isClickable = false
            connect = GingerSoftConnect()
            msgSender = connect!!.connect(
                "192.168.002.206",
                9100,
                10,
                object : GingerSoftConnect.SocketStateListener {
                    override fun onOpen() {
                        super.onOpen()
                        runOnUiThread {
                            tvConnect.text = "已連接"
                            tvConnect.isClickable = true
                        }
                    }

                    override fun onClose(code: Int, reason: String?, remote: Boolean) {
                        super.onClose(code, reason, remote)
                        runOnUiThread {
                            tvConnect.text = "已斷開：$code,$reason"
                            tvConnect.isClickable = true
                        }
                    }

                    override fun onError(ex: Exception?) {
                        super.onError(ex)
                        runOnUiThread {
                            tvConnect.isClickable = true
                            tvConnect.text = "發生錯誤：${ex?.message}"
                        }
                    }

                })
        }

        tvDisconnect.setOnClickListener {
            connect?.disconnect()
        }
        var count = 0
        tvSendMsg.setOnClickListener {
            count++
            val order = OrderInfoBean().apply {
                orderId = 1111L + count
                orderNo = "00$count"
                orderType = 1
                pax = 10
                senderId = 1965.toString()
                senderName = "Glen$count"
                tableName = "餐檯$count"
                sendTime = "2023-05-31 12:31:31"
                sendDeviceId = "6464646sdfs"
                sendDeviceName = "POS$count"
                sendOrderCount = 4 + count
                isFirstSendOrder = true
                foodInfoBeanList = mutableListOf<FoodInfoBean>().apply {
                    add(FoodInfoBean().apply {
                        foodId = "1"
                        printId = "11661"
                        orderId = 1111L + count
                        foodName = "經典雙人套餐"
                        quantity = count
                        price = count * 1.1
                        type = 1
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "2"
                        printId = "11662"
                        orderId = 1111L + count
                        foodName = "宮保雞丁"
                        quantity = count
                        price = count * 1.1
                        type = 2
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "3"
                        printId = "11663"
                        orderId = 1111L + count
                        foodName = "細項名稱、細項名稱"
                        quantity = count
                        price = count * 1.1
                        type = 3
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "4"
                        printId = "11664"
                        orderId = 1111L + count
                        foodName = "奶茶"
                        quantity = count
                        price = count * 1.1
                        type = 1
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "5"
                        printId = "11665"
                        orderId = 1111L + count
                        foodName = "珍珠、芋圓"
                        quantity = count
                        price = count * 1.1
                        type = 3
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "6"
                        printId = "11666"
                        orderId = 1111L + count
                        foodName = "酸辣粉"
                        quantity = count
                        price = count * 1.1
                        type = 1
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "7"
                        printId = "11667"
                        orderId = 1111L + count
                        foodName = "經典雙人套餐"
                        quantity = count
                        price = count * 1.1
                        type = 1
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "8"
                        printId = "11668"
                        orderId = 1111L + count
                        foodName = "宮保雞丁"
                        quantity = count
                        price = count * 1.1
                        type = 2
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "9"
                        printId = "11669"
                        orderId = 1111L + count
                        foodName = "細項名稱、細項名稱"
                        quantity = count
                        price = count * 1.1
                        type = 3
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "10"
                        printId = "11670"
                        orderId = 1111L + count
                        foodName = "奶茶"
                        quantity = count
                        price = count * 1.1
                        type = 1
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "11"
                        printId = "11671"
                        orderId = 1111L + count
                        foodName = "珍珠、芋圓"
                        quantity = count
                        price = count * 1.1
                        type = 3
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "1"
                        printId = "11661"
                        orderId = 1111L + count
                        foodName = "經典雙人套餐"
                        quantity = count
                        price = count * 1.1
                        type = 1
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "1"
                        printId = "11661"
                        orderId = 1111L + count
                        foodName = "經典雙人套餐"
                        quantity = count
                        price = count * 1.1
                        type = 1
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                    add(FoodInfoBean().apply {
                        foodId = "1"
                        printId = "11661"
                        orderId = 1111L + count
                        foodName = "經典雙人套餐"
                        quantity = count
                        price = count * 1.1
                        type = 1
                        parentId = "0"
                        isPrintRedLetter = false
                    })
                }
            }
            msgSender?.initSendData(Action.KitchenInfo, order)
                ?.asyncSend(object : SendCallback {
                    override fun callback(status: Boolean, errorCode: Int, errorMessage: String) {
                        runOnUiThread {
                            tvSendValue.text = if (status) "發送成功" else "發生錯誤：$errorMessage"
                        }
                    }
                })
        }
    }
}