package com.gingersoft.connect.bean

class SoldOutMsgBean : SendMsgType() {
    companion object {
        /** 新增沽清 */
        const val MSG_TYPE_INSERT = 1

        /** 恢復單個沽清 */
        const val MSG_TYPE_RESTORE_SINGLE = 2

        /** 恢復全部沽清 **/
        const val MSG_TYPE_RESTORE_ALL = 3

        /** 暫停組別 **/
        const val MSG_TYPE_PAUSE_GROUP = 4
    }

    /** 消息類型 */
    var msgType: Int = 0

    /**
     * 食品id
     */
    var foodId: String? = null

    /**
     * 食品類型
     */
    var type = 0

    /**
     * 如果為0，type為1 || 2，則是食品組
     * 如果有值，type為1 || 2，則是食品
     * 如果為0，type為3，則是細項組
     * 如果有值，type為3，則是細項
     */
    var parentId: String? = null

    /**
     * 食品數量
     * 如果是組，並且為0，就是暫停
     */
    var inventoryQuantity: String? = null

    /**
     * 沽清id，某些系統沽清後，會單獨生成沽清記錄，需要通過這個id去操作沽清
     */
    var soldOutId: String? = null
}