package com.gingersoft.connect.utils

import com.gingersoft.connect.bean.MessageBuilder
import java.net.URI

class GingerSoftConnect {

    private var webSocketClient: MyWebSocketClient? = null

    fun connect(ip: String, port: Int, listener: SocketStateListener?): MessageBuilder {
        val uri = URI("ws://$ip:$port")
        webSocketClient = MyWebSocketClient(uri, listener)
        webSocketClient?.connect()
        // 連接成功後獲得發送類
        return MessageBuilder(this, webSocketClient!!)
    }

    fun disconnect() {
        webSocketClient?.close()
    }

    interface SocketStateListener {
        fun onOpen() {}

        fun onClose(code: Int, reason: String?, remote: Boolean) {}

        fun onError(ex: Exception?) {}
    }

}