package com.example.demo

import android.app.Activity
import android.os.Bundle
import android.util.Log
import android.widget.TextView
import com.example.gingersoft_connect.R
import com.gingersoft.connect.SendCallback
import com.gingersoft.connect.bean.Action
import com.gingersoft.connect.bean.FoodInfoBean
import com.gingersoft.connect.bean.MessageBuilder
import com.gingersoft.connect.bean.MessageSender
import com.gingersoft.connect.bean.OrderInfoBean
import com.gingersoft.connect.utils.GingerSoftConnect
import java.text.SimpleDateFormat
import java.util.Date

class MainActivity : Activity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        var msgSender: MessageBuilder? = null
        var connect: GingerSoftConnect? = null
        val tvConnect = findViewById<TextView>(R.id.tv_connect)
        val tvDisconnect = findViewById<TextView>(R.id.tv_disconnect)
        val tvSendMsg = findViewById<TextView>(R.id.tv_send_msg)
        val tvSendValue = findViewById<TextView>(R.id.tv_send_value)

        tvConnect.setOnClickListener {
            tvConnect.isClickable = false
            connect = GingerSoftConnect()
            msgSender = connect!!.connect(
                "192.168.1.19",
                12581,
                object : GingerSoftConnect.SocketStateListener {
                    override fun onOpen() {
                        super.onOpen()
                        runOnUiThread {
                            tvConnect.text = "已連接"
                            tvConnect.isClickable = true
                        }
                    }

                    override fun onClose(code: Int, reason: String?, remote: Boolean) {
                        super.onClose(code, reason, remote)
                        runOnUiThread {
                            tvConnect.text = "已斷開：$code,$reason"
                            tvConnect.isClickable = true
                        }
                    }

                    override fun onError(ex: Exception?) {
                        super.onError(ex)
                        runOnUiThread {
                            tvConnect.isClickable = true
                            tvConnect.text = "發生錯誤：${ex?.message}"
                        }
                    }

                })
        }

        tvDisconnect.setOnClickListener {
            connect?.disconnect()
        }
        var count = 0
        tvSendMsg.setOnClickListener {
            count++
            val order = OrderInfoBean().apply {
                orderId = 1111L + count
                orderNo = "00$count"
                orderType = 1
                pax = 10
                senderId = 1965.toString()
                senderName = "Glen$count"
                sendTime = SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Date())
                sendDeviceId = "6464646sdfs"
                sendDeviceName = "POS$count"
                sendOrderCount = 4 + count
                isFirstSendOrder = true
                flyPrintInfo = "K1-L2"
                foodInfoBeanList = mutableListOf<FoodInfoBean>().apply {
                    for (i in 0 until 10) {
                        add(FoodInfoBean().apply {
                            foodId = "${1 + i}"
                            printId = "1166$i"
                            orderId = 1111L + count
                            foodName = "這是一個名字超級長的食品，"
                            quantity = count.toString()
                            price = count * 1.1
                            type = (i % 3) + 1
                            parentId = "0"
                            isPrintRedLetter = false
                        }
                        )
                    }
                }
            }
            msgSender?.initSendData(Action.KitchenInfo, order)
                ?.asyncSend(object : SendCallback {
                    override fun callback(status: Boolean, errorCode: Int, errorMessage: String) {
                        runOnUiThread {
                            tvSendValue.text = if (status) "發送成功" else "發生錯誤：$errorMessage"
                        }
                    }
                })
        }
    }
}