package com.gingersoft.connect.utils

import com.gingersoft.connect.bean.ResultBean
import com.gingersoft.connect.bean.SoldOutMsgBean

interface SoldOutMsgProcess : MsgProcess {
    override fun processMsg(data: Any?): ResultBean {
        val gsonToBean = GsonUtils.GsonToBean(data, SoldOutMsgBean::class.java)
        if (gsonToBean == null) {
            return ResultBean(false, "解析失敗")
        }
        return processSoldOutMsg(gsonToBean)
    }

    fun processSoldOutMsg(data: SoldOutMsgBean?): ResultBean

}