package com.gingersoft.connect.utils

import android.util.Log
import com.gingersoft.connect.bean.MessageBean
import com.gingersoft.connect.bean.SocketCallbackBean

/**
 * 消息中轉，由具體的類去處理具體的事
 */
object MsgParser {

    val parserMap by lazy { mutableMapOf<String, MsgProcess>() }

    suspend fun process(msgBean: MessageBean?): SocketCallbackBean? {
        return if (msgBean != null) {
            Log.e("MyWebSocketServer", "開始處理消息:${parserMap.keys},${msgBean.action}")
            val result = parserMap[msgBean.action.toString()]?.processMsg(msgBean.data)
            Log.e("MyWebSocketServer", "消息處理結果:$result")
            if (result != null) {
                SocketCallbackBean(
                    result.success,
                    200,
                    msgBean.code.toString(),
                    result.errorMsg,
                    GsonUtils.GsonString(result.data)
                )
            } else {
                return null
            }
        } else {
            null
        }
    }
}