package com.gingersoft.gsa.cloud.common.printer.plugins;

import android.graphics.Bitmap;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;

import java.util.List;
import java.util.Map;

/**
 * @作者: bin
 * @創建時間: 2021-01-25 10:19
 * @更新時間: 2021-01-25 10:19
 * @描述:打印整體打印流程(打印前數據信息,圖片->連接成功(失敗)->打印成功(失敗)->斷開連接)
 */
public interface PrinterFlowListener extends ExternalPrinterConnection {

    void onPrinterDataBefore(int orderType,String printerData,String printerDeviceInfo);

    void onPrinterBitmapBefore(int orderType,String directoryName, List<Map<String, Bitmap>> bitmaps);

    void onPrintSuccess(PrinterDeviceBean printerDeviceBean);

    void onPrintError(int errorCode, PrinterDeviceBean printerDeviceBean);
}
