package com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos;

import android.os.Parcel;
import android.os.Parcelable;

import lombok.Data;

/**
 * @作者: bin
 * @創建時間: 2020-12-29 11:48
 * @更新時間: 2020-12-29 11:48
 * @描述:
 */
@Data
public class HywebPosResponse implements Parcelable {

    protected String EVENT_NAME;
    protected String STATUS;

    protected String TXN_ID;
    protected double TXN_AMT = 0.0;
    protected double TIPS = 0.0;

    public HywebPosResponse() {
    }

    public static final Creator<HywebPosResponse> CREATOR = new Creator<HywebPosResponse>() {
        @Override
        public HywebPosResponse createFromParcel(Parcel in) {
            return new HywebPosResponse(in);
        }

        @Override
        public HywebPosResponse[] newArray(int size) {
            return new HywebPosResponse[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.EVENT_NAME);
        dest.writeString(this.STATUS);
        dest.writeString(this.TXN_ID);
        dest.writeDouble(this.TXN_AMT);
        dest.writeDouble(this.TIPS);
    }

    protected HywebPosResponse(Parcel in) {
        this.EVENT_NAME = in.readString();
        this.STATUS = in.readString();
        this.TXN_ID = in.readString();
        this.TXN_AMT = in.readDouble();
        this.TIPS = in.readDouble();
    }

}
