package com.gingersoft.supply_chain.mvp.ui.adapter

import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.gingersoft.supply_chain.R
import com.gingersoft.supply_chain.mvp.bean.WarehouseOrderBean

/**
 * @author 宇航. 1239658231@qq.com
 * User: admin
 * Date: 2021/4/28
 * Time: 14:19
 * Use:
 */
class WarehousingOrderListAdapter(data: MutableList<WarehouseOrderBean>?) : BaseQuickAdapter<WarehouseOrderBean, BaseViewHolder>(R.layout.item_warehousing_order_list, data) {

    override fun convert(holder: BaseViewHolder, item: WarehouseOrderBean) {
        holder.setText(R.id.tv_warehousing_order_no, item.orderNo)
        holder.setText(R.id.tv_warehousing_order_createTime, item.warehousingTime)
        holder.setText(R.id.tv_warehousing_order_species, item.warehousingSpecies)
        holder.setText(R.id.tv_warehousing_order_createMember, item.warehousingMember)
        holder.setText(R.id.tv_warehousing_order_foods, item.warehousingFoodName)
        holder.setText(R.id.tv_warehousing_order_createReason, item.warehousingReason)
    }
}