package com.gingersoft.gsa.cloud.common.printer;

import android.graphics.Bitmap;
import android.text.TextUtils;

import com.gingersoft.gsa.cloud.common.constans.PrintConstans;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.common.utils.FileUtils;
import com.gingersoft.gsa.cloud.common.utils.view.BitmapUtil;
import com.xuexiang.rxutil2.rxjava.RxJavaUtils;
import com.xuexiang.rxutil2.rxjava.task.RxIOTask;

import java.io.File;
import java.util.List;

/**
 * @作者: bin
 * @創建時間: 2021-01-29 16:04
 * @更新時間: 2021-01-29 16:04
 * @描述:
 */
public class PrinterFileUtils {

    private static final String TAG = "PrinterFileUtils";
    //圖片文件最大文件大小不能超過100M
    public static final int PRINTER_MAX_FILE_SIZE = 100 * 1024 * 1024;
    //最少保留多少打印圖片文件大小
    public static final int PRINTER_KEEP_FILE_SIZE = 20 * 1024 * 1024;

    //根目錄
    public static final String PrinterImagesRootPath = "PrinterImages";
    /**
     * 廚房單
     * 堂食結賬單
     * 堂食印單
     * 堂食上菜紙
     * QRCODE
     * 外送印單
     * 外送結賬單
     * 清機單
     */
    public static final String KitchenImage = "廚房單";
    public static final String PrintOrderImage = "堂食印單";
    public static final String BillImage = "堂食結賬單";
    public static final String ServingPaperImage = "上菜紙";
    public static final String QrcodeImage = "Qrcode";
    public static final String DeliveryPrintOrderImage = "外賣印單";
    public static final String DeliveryBillImage = "外賣結賬單";
    public static final String SettlementImage = "清機";

    public final static String ROOT_PATH = FileUtils.ALBUM_PATH + PrinterImagesRootPath + File.separator;
    public final static String KITCHEN_PRJ_IMAGE_PATH = ROOT_PATH + KitchenImage + File.separator;
    public final static String PRINT_ORDER_IMAGE_PATH = ROOT_PATH + PrintOrderImage + File.separator;
    public final static String BILL_IMAGE_PATH = ROOT_PATH + BillImage + File.separator;
    public final static String SERVING_PAPER_IMAGE_PATH = ROOT_PATH + ServingPaperImage + File.separator;
    public final static String DELIVERY_PRINT_ORDER_IMAGE_PATH = ROOT_PATH + DeliveryPrintOrderImage + File.separator;
    public final static String DELIVERY_BILL_IMAGE_PATH = ROOT_PATH + DeliveryBillImage + File.separator;
    public final static String QRCODE_IMAGE_PATH = ROOT_PATH + QrcodeImage + File.separator;
    public final static String SETTLEMENT_IMAGE_PATH = ROOT_PATH + SettlementImage + File.separator;

    public static void savePrinterBitmapByType(int orderType, int printType, String directoryName, List<Bitmap> bitmaps) {
        RxIOTask rxIOTask = new RxIOTask(0) {
            @Override
            public Object doInIOThread(Object o) {
                String savePath = getPathByPrintType(printType);
                if (TextUtils.isEmpty(savePath)) {
                    return null;
                }
                LoganManager.w_printer(TAG, "保存打印圖片到本地 path = " + savePath);
                File rootFileDir = new File(ROOT_PATH);
                if (rootFileDir != null && rootFileDir.exists()) {
                    long FILE_SIZE = FileUtils.getDirSize(rootFileDir);
                    if (FILE_SIZE > PRINTER_MAX_FILE_SIZE) {
                        LoganManager.w_printer(TAG, "刪除本地打印圖片 before size = " + FILE_SIZE);
                        //大於100M 就刪除
                        File prjPath = new File(ROOT_PATH);
                        if (prjPath.isDirectory()) {
                            File[] prjDirectorys = prjPath.listFiles();
                            for (int i = prjDirectorys.length - 1; i >= 0; i--) {
                                File prjDirectory = prjDirectorys[i];
                                boolean deleteResult = prjDirectory.delete();
                                if (deleteResult && FILE_SIZE <= PRINTER_KEEP_FILE_SIZE) {
                                    FILE_SIZE = FileUtils.getDirSize(rootFileDir);
                                    LoganManager.w_printer(TAG, "刪除本地打印圖片 after size = " + FILE_SIZE);
                                    break;
                                }
                            }
                        }
                    }
                }
                for (Bitmap bitmap : bitmaps) {
                    String fileName = directoryName + "-" + System.currentTimeMillis();
                    LoganManager.w_printer(TAG, "fileName : " + fileName);
                    BitmapUtil.saveBitmap(bitmap, savePath + directoryName + File.separator, fileName + ".jpeg", new BitmapUtil.OnSaveBitmapListener() {

                        @Override
                        public void onSuccess() {
                            LoganManager.w_printer(TAG, "保存打印圖片成功");
                        }

                        @Override
                        public void onError(Exception e) {
                            LoganManager.w_printer(TAG, "保存打印圖片失敗 onError ：" + e.getMessage());
                        }
                    });
                }
                return null;
            }
        };
        RxJavaUtils.doInIOThread(rxIOTask);
    }


    private static String getPathByPrintType(int printType) {
        switch (printType) {
            case PrintConstans.PRINT_SERVE: //堂食上菜紙
                return PrinterFileUtils.SERVING_PAPER_IMAGE_PATH;
            case PrintConstans.PRINT_SLIP://堂食印單
                return PrinterFileUtils.PRINT_ORDER_IMAGE_PATH;
            case PrintConstans.PRINT_BILL://堂食結賬單
                return PrinterFileUtils.BILL_IMAGE_PATH;
            case PrintConstans.PRINT_SKYORDER_QRCODE://QRCODE
                return PrinterFileUtils.QRCODE_IMAGE_PATH;
            case PrintConstans.PRINT_KITCHEN://廚房單 PRJ
                return PrinterFileUtils.KITCHEN_PRJ_IMAGE_PATH;
            case PrintConstans.PRINT_OTHER_ORDER://外送印單
                return PrinterFileUtils.DELIVERY_PRINT_ORDER_IMAGE_PATH;
            case PrintConstans.PRINT_OTHER_CLOSING://外送結賬
                return PrinterFileUtils.DELIVERY_BILL_IMAGE_PATH;
            case PrintConstans.PRINT_CLEAN_MACHINE://清機報表
                return PrinterFileUtils.SETTLEMENT_IMAGE_PATH;
        }
        return null;
    }


}
