package com.gingersoft.gsa.cloud.order.bean.request;

import android.os.Parcel;
import android.os.Parcelable;

import com.gingersoft.gsa.cloud.pay.pos.bean.PosMatter;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-07-25
 * 修订历史：2020-07-25
 * 描述：堂食支付請求數據
 */
@Data
public class MealOrderPayRequest implements Parcelable{

    private long orderId;
    private int linePayType;
    private int orderPayType;
    private int tableId;
    private String tableNumber;
    private Long memberId;
    private Long couponId;
    /**當前加的積分*/
    private Double pointsAdd;
    /**當前減去的積分*/
    private Double pointsUse;
    /**
     * 是否免服務費(0:否 1：是)
     */
    private int whetherFreeService;
    private List<OrderPay> orderPays = new ArrayList<>();

    /**
     * Pos支付狀態更新
     */
    private PosMatter posMatter;


    public MealOrderPayRequest() {
    }


    @Override
    public String toString() {
        return "MealOrderPayRequest{" +
                "orderId=" + orderId +
                ", linePayType=" + linePayType +
                ", orderPayType=" + orderPayType +
                ", tableId=" + tableId +
                ", tableNumber='" + tableNumber + '\'' +
                ", memberId=" + memberId +
                ", couponId=" + couponId +
                ", pointsAdd=" + pointsAdd +
                ", pointsUse=" + pointsUse +
                ", whetherFreeService=" + whetherFreeService +
                ", orderPays=" + orderPays +
                ", posMatter=" + posMatter +
                '}';
    }

    @Data
    public static class OrderPay implements Parcelable {
        private int payType;
        private double amount;
        private double tipsPrice;
        /**積分支付 所消費的積分*/
        private Double consumptionPoints;

        public OrderPay() {
        }

        @Override
        public String toString() {
            return "OrderPay{" +
                    "payType=" + payType +
                    ", amount=" + amount +
                    ", tipsPrice=" + tipsPrice +
                    ", consumptionPoints=" + consumptionPoints +
                    '}';
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.payType);
            dest.writeDouble(this.amount);
            dest.writeDouble(this.tipsPrice);
            dest.writeValue(this.consumptionPoints);
        }

        protected OrderPay(Parcel in) {
            this.payType = in.readInt();
            this.amount = in.readDouble();
            this.tipsPrice = in.readDouble();
            this.consumptionPoints = (Double) in.readValue(Double.class.getClassLoader());
        }

        public static final Creator<OrderPay> CREATOR = new Creator<OrderPay>() {
            @Override
            public OrderPay createFromParcel(Parcel source) {
                return new OrderPay(source);
            }

            @Override
            public OrderPay[] newArray(int size) {
                return new OrderPay[size];
            }
        };
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.orderId);
        dest.writeInt(this.linePayType);
        dest.writeInt(this.orderPayType);
        dest.writeInt(this.tableId);
        dest.writeString(this.tableNumber);
        dest.writeValue(this.memberId);
        dest.writeValue(this.couponId);
        dest.writeValue(this.pointsAdd);
        dest.writeValue(this.pointsUse);
        dest.writeInt(this.whetherFreeService);
        dest.writeTypedList(this.orderPays);
        dest.writeParcelable(this.posMatter, flags);
    }

    protected MealOrderPayRequest(Parcel in) {
        this.orderId = in.readLong();
        this.linePayType = in.readInt();
        this.orderPayType = in.readInt();
        this.tableId = in.readInt();
        this.tableNumber = in.readString();
        this.memberId = (Long) in.readValue(Long.class.getClassLoader());
        this.couponId = (Long) in.readValue(Long.class.getClassLoader());
        this.pointsAdd = (Double) in.readValue(Double.class.getClassLoader());
        this.pointsUse = (Double) in.readValue(Double.class.getClassLoader());
        this.whetherFreeService = in.readInt();
        this.orderPays = in.createTypedArrayList(OrderPay.CREATOR);
        this.posMatter = in.readParcelable(PosMatter.class.getClassLoader());
    }

    public static final Creator<MealOrderPayRequest> CREATOR = new Creator<MealOrderPayRequest>() {
        @Override
        public MealOrderPayRequest createFromParcel(Parcel source) {
            return new MealOrderPayRequest(source);
        }

        @Override
        public MealOrderPayRequest[] newArray(int size) {
            return new MealOrderPayRequest[size];
        }
    };


}
