package com.joe.print.mvp.ui.view;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.joe.print.R;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/30
 * Time: 11:16
 * Use:結賬單，支付方式的view
 */
public class BillTypeView extends LinearLayout {

    private List<PrintBillItem> data;

    public BillTypeView(Context context, List<PrintBillItem> data) {
        super(context);
        this.data = data;
        init();
    }

    private void init() {
        for (PrintBillItem item : data) {
            View view = View.inflate(getContext(), R.layout.base_print_item_bill_type, null);
            TextView tvBillTotalText = view.findViewById(R.id.tv_total_amount_text);
            TextView tvBillTotal = view.findViewById(R.id.tv_total_amount);
            tvBillTotalText.setText(item.getBillName());
            tvBillTotal.setText("$" + item.getBillAmount());
            addView(view);
        }
    }
}
