package com.gingersoft.gsa.cloud.pay.pos.hywebpos.imp;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.common.utils.okhttpUtils.OkHttp3Utils;
import com.gingersoft.gsa.cloud.pay.contract.PayExceptionCode;
import com.gingersoft.gsa.cloud.pay.pos.IPosAction;
import com.gingersoft.gsa.cloud.pay.pos.OnPosActionListener;
import com.gingersoft.gsa.cloud.pay.pos.PosAction;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.SettlementRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.bg.GetRefundIdResponse;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.HywebPosResponse;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.RetrievalRespose;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.SettlementRespose;
import com.jess.arms.mvp.IView;
import com.jess.arms.utils.RxLifecycleUtils;
import com.xuexiang.rxutil2.rxjava.RxSchedulerUtils;

import javax.inject.Inject;

import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.RequestBody;

/**
 * @作者: bin
 * @創建時間: 2020-12-26 10:38
 * @更新時間: 2020-12-26 10:38
 * @描述:
 */
public class SettlementActionImpl extends IPosAction<SettlementRespose> {


    public SettlementActionImpl(Context context, IView iView, PosAction action, OnPosActionListener onPosActionListener, boolean showLoading) {
        super(context,iView,action,showLoading);
        this.mOnPosActionListener = onPosActionListener;
    }

    @Override
    protected void onPosActionBefore() {

        SettlementRequest request = new SettlementRequest();
        onPosToAction(GsonUtils.GsonString(request));

//        RequestBody requestBody = RequestBody.create(MediaType.parse("application/json"), GsonUtils.GsonString(mGetTxnIdRequest));
//        String json = GsonUtils.GsonString(mGetTxnIdRequest);

//        OkHttp3Utils.post(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL + "posPay/addOperation", null)
//                .compose(RxSchedulerUtils._io_main_o())
//                .compose(RxLifecycleUtils.bindToLifecycle(mView))
//                .subscribe(new Observer<String>() {
//                    @Override
//                    public void onSubscribe(Disposable d) {
//                    }
//
//                    @Override
//                    public void onNext(String result) {
//                        String error = "調起清機款異常";
//                        if (!TextUtils.isEmpty(result)) {
//                            BaseResult baseResult = GsonUtils.GsonToBean(result, BaseResult.class);
//                            if (baseResult != null) {
//                                if (baseResult.isSuccess() && baseResult.getData() != null) {
//                                    //調起N5清機
////                                    onPosToAction(GsonUtils.GsonString(mRefundRequest));
//                                } else {
//                                    onBeforeActionPosError(new Exception(error + baseResult.getErrMsg()));
//                                }
//                            } else {
//                                onBeforeActionPosError(new Exception(error + PayExceptionCode.tips_703));
//                            }
//                        } else {
//                            onBeforeActionPosError(new Exception(error + PayExceptionCode.tips_704));
//                        }
//                    }
//
//                    @Override
//                    public void onComplete() {
//                    }
//
//                    @Override
//                    public void onError(Throwable t) {
//                        onBeforeActionPosError(new Exception(t.getMessage()));
//                    }
//                });
    }

    @Override
    public void onPosSuccess(Context context, Activity originalActivity, SettlementRespose response) {
        updateMatter(context,originalActivity,response,response.getSTATUS());
    }

    @Override
    public void onPosException(Context context, Activity originalActivity, SettlementRespose response) {
        updateMatter(context,originalActivity,response,response.getSTATUS());
    }

    @Override
    public void onPosInvalid(Context context, Activity originalActivity, SettlementRespose response) {
        updateMatter(context,originalActivity,response,response.getSTATUS());
    }

    /**
     * 1、更新上傳清機結果
     *
     * @param context
     * @param originalActivity
     * @param response
     * @param status
     */
    private void updateMatter(Context context, Activity originalActivity, SettlementRespose response, String status){
        //1、更新上傳清機結果
        OkHttp3Utils.post(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL + "posPay/updateOperation", getPosSettlementRequest(response))
                .compose(RxSchedulerUtils._io_main_o())
                .compose(RxLifecycleUtils.bindToLifecycle(mView))
                .subscribe(new Observer<String>() {

                    @Override
                    public void onSubscribe(Disposable d) {
                    }

                    @Override
                    public void onNext(String result) {

//                        displayTipsResult(context, response, originalActivity);

                        if (!TextUtils.isEmpty(result)) {
                            BaseResult baseResult = GsonUtils.GsonToBean(result, BaseResult.class);
                            if (baseResult != null) {
                                if (baseResult.isSuccess()) {
//                                    onUpdateStatusSuccess(response);
                                } else {
//                                    onUpdateStatusError(new Exception(mPosAction.getCallbackExceptionText() + PayExceptionCode.tips_711));
                                    onUpdateStatusError(new Exception(mPosAction.getCallbackExceptionText() + "["+baseResult.getErrMsg()+"]"));
                                }
                            } else {
                                onUpdateStatusError(new Exception(mPosAction.getCallbackExceptionText() + PayExceptionCode.tips_712));
                            }
                        } else {
                            onUpdateStatusError(new Exception(mPosAction.getCallbackExceptionText() + PayExceptionCode.tips_713));
                        }
                    }

                    @Override
                    public void onError(Throwable e) {
//                        displayTipsResult(context, response, originalActivity);
                    }

                    @Override
                    public void onComplete() {
                    }
                });
    }

    private RequestBody getPosSettlementRequest(SettlementRespose result) {
        RequestBody requestBody = new FormBody.Builder()
                .add("restaurantId",String.valueOf(RestaurantInfoManager.newInstance().getRestaurantId()))
                .add("content",GsonUtils.GsonString(result))
//                .add("status",String.valueOf(status))
                .build();
        return requestBody;
    }

}
