/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio;

import com.epson.epsonio.NetIfResult;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NetIFInfo {
    public static int getNetInfoNum(int[] netIfNum) {
        int nNetIfNum = 0;
        try {
            Enumeration<NetworkInterface> netIFs = NetworkInterface.getNetworkInterfaces();
            while (netIFs.hasMoreElements()) {
                NetworkInterface netIF = netIFs.nextElement();
                Enumeration<InetAddress> ipAddrs = netIF.getInetAddresses();
                while (ipAddrs.hasMoreElements()) {
                    InetAddress ip = ipAddrs.nextElement();
                    if (ip.isLoopbackAddress()) continue;
                    if (ip instanceof Inet4Address) {
                        ++nNetIfNum;
                        continue;
                    }
                    if (!ip.isLinkLocalAddress() && !(ip instanceof Inet6Address)) continue;
                }
            }
        }
        catch (SocketException e) {
            return 255;
        }
        netIfNum[0] = nNetIfNum;
        return 0;
    }

    public static NetIfResult[] getNetInfoList(int netIfNum) {
        int index = 0;
        boolean netIfFin = false;
        NetIfResult[] netIfResult = new NetIfResult[netIfNum];
        try {
            Enumeration<NetworkInterface> netIFs = NetworkInterface.getNetworkInterfaces();
            while (netIFs.hasMoreElements() && !netIfFin) {
                NetworkInterface netIF = netIFs.nextElement();
                Enumeration<InetAddress> ipAddrs = netIF.getInetAddresses();
                while (ipAddrs.hasMoreElements()) {
                    InetAddress ip = ipAddrs.nextElement();
                    if (ip.isLoopbackAddress()) continue;
                    if (ip instanceof Inet4Address) {
                        netIfResult[index] = new NetIfResult();
                        netIfResult[index].NetIfsetIpAddress(ip.getAddress());
                        if (++index != netIfNum) continue;
                        netIfFin = true;
                        continue;
                    }
                    if (!ip.isLinkLocalAddress() && !(ip instanceof Inet6Address)) continue;
                }
            }
        }
        catch (SocketException e) {
            return null;
        }
        return netIfResult;
    }
}

