package com.gingersoft.gsa.cloud.main.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.main.mvp.contract.BusinessReportContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.BusinessDetailsBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DaySalesReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.DiscountDetailsReportBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.MainBusinessBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.OrderAnalysisBean;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.OrderDetailsReport;
import com.gingersoft.gsa.cloud.main.mvp.model.service.MainReportService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import java.util.Map;

import javax.inject.Inject;

import io.reactivex.Observable;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/23/2020 16:19
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class BusinessReportModel extends BaseModel implements BusinessReportContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public BusinessReportModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<MainBusinessBean> getRestaurantBusinessAmount(Map<String, String> map) {
        return mRepositoryManager.obtainRetrofitService(MainReportService.class)
                .getRestaurantAmount(map);
    }

//    @Override
//    public Observable<BusinessDetailsBean> getRestaurantBusinessDetails(Map<String, String> map) {
//        return mRepositoryManager.obtainRetrofitService(MainReportService.class)
//                .getRestaurantDetails(map);
//    }

    @Override
    public Observable<DaySalesReportBean> getDaySalesReport(Map<String, String> map) {
        return mRepositoryManager.obtainRetrofitService(MainReportService.class)
                .getDaySalesReport(map);
    }

    @Override
    public Observable<OrderAnalysisBean> getOrderAnalysis(Map<String, String> map) {
        return mRepositoryManager.obtainRetrofitService(MainReportService.class)
                .getOrderAnalysis(map);
    }

    @Override
    public Observable<OrderDetailsReport> getOrderDetailsReport(Map<String, String> map) {
        return mRepositoryManager.obtainRetrofitService(MainReportService.class)
                .getOrderDetailsReport(map);
    }

    @Override
    public Observable<DiscountDetailsReportBean> getDiscountDetails(Map<String, String> map) {
        return mRepositoryManager.obtainRetrofitService(MainReportService.class)
                .getDiscountDetails(map);
    }


}
