package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.widget.TextView;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.BusinessBean;

import java.util.List;

/**
 * Created by Wyh on 2020/2/24.
 */
public class BusinessInfoAdapter extends BaseQuickAdapter<BusinessBean, BaseViewHolder> {

    private boolean isPrint;

    public BusinessInfoAdapter(@Nullable List<BusinessBean> data, boolean isPrint) {
        super(R.layout.report_business_info_item, data);
        this.isPrint = isPrint;
    }

    @Override
    protected void convert(BaseViewHolder helper, BusinessBean item) {
        helper.setText(R.id.tv_business_info_amount, item.getAmount());
        helper.setText(R.id.tv_business_info_name, item.getProjectName());
        if (isPrint) {
            ((TextView) helper.getView(R.id.tv_business_info_name)).setTextSize(22);
            ((TextView) helper.getView(R.id.tv_business_info_amount)).setTextSize(22);
            helper.setBackgroundColor(R.id.horizontal_dividing_line, R.color.black);
            helper.setBackgroundColor(R.id.vertical_dividing_line, R.color.black);
        } else {
            ((TextView) helper.getView(R.id.tv_business_info_amount)).setTextSize(18);
            ((TextView) helper.getView(R.id.tv_business_info_name)).setTextSize(12);
        }
    }
}
