package com.gingersoft.gsa.cloud.table.di.module;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;

import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealStandContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.SoldoutCtrFood;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.ComboAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.FoodAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.FoodGroupAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.ModifierAdapter;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.di.scope.ActivityScope;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;

import com.gingersoft.gsa.cloud.table.mvp.model.MealStandModel;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Named;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/17/2021 10:40
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@Module
public abstract class MealStandModule {

    @Binds
    abstract MealStandContract.Model bindSetMealModel(MealStandModel model);

    @ActivityScope
    @Provides
    @Named("foodGroupList")
    static List<Food> provideFoodGroupList() {
        return new ArrayList<>();
    }

    @ActivityScope
    @Provides
    @Named("foodList")
    static List<Food> provideFoodList() {
        return new ArrayList<>();
    }

    @ActivityScope
    @Provides
    static List<ComboItem> provideFoodCombo() {
        return new ArrayList<>();
    }

    @ActivityScope
    @Provides
    static List<Modifier> provideModifierList() {
        return new ArrayList<>();
    }

    @ActivityScope
    @Provides
    static List<SoldoutCtrFood> provideSoldoutCtrList() {
        return new ArrayList<>();
    }

    @ActivityScope
    @Provides
    static FoodGroupAdapter provideFoodGroupAdapter(MealStandContract.View IView, @Named("foodGroupList") List<Food> foodGroupList) {
        return new FoodGroupAdapter(IView.getActivity(), foodGroupList, IView.getFromType());
    }

    @ActivityScope
    @Provides
    static FoodAdapter provideFoodAdapter(MealStandContract.View IView, @Named("foodList") List<Food> foodList) {
        return new FoodAdapter(IView.getActivity(), foodList, IView.getFromType());
    }

    @ActivityScope
    @Provides
    static ComboAdapter provideComboAdapter(MealStandContract.View IView, List<ComboItem> comboItemList) {
        return new ComboAdapter(IView.getActivity(), comboItemList);
    }

    @ActivityScope
    @Provides
    static ModifierAdapter provideModifierAdapter(MealStandContract.View IView, List<Modifier> modifierList) {
        return new ModifierAdapter(IView.getActivity(), modifierList);
    }

    @ActivityScope
    @Provides
    @Named("comboGridLayoutManager")
    static GridLayoutManager provideComboRecycleLayoutManager(MealStandContract.View IView) {
        return new GridLayoutManager(IView.getActivity(), 1, LinearLayoutManager.HORIZONTAL, false);
    }

    @ActivityScope
    @Provides
    @Named("modifierGridLayoutManager")
    static GridLayoutManager provideModifierRecycleLayoutManager(MealStandContract.View IView) {
        return new GridLayoutManager(IView.getActivity(), 1, LinearLayoutManager.HORIZONTAL, false);
    }

}