package com.gingersoft.gsa.cloud.table.mvp.model.bean.event;

import android.os.Parcel;
import android.os.Parcelable;

import com.gingersoft.gsa.cloud.table.mvp.model.bean.SoldoutCtrFood;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * @作者: bin
 * @創建時間: 2021-04-27 14:26
 * @更新時間: 2021-04-27 14:26
 * @描述:
 */
@Data
public class LoadFineEvent implements Parcelable {

    private int currFinePage;
    private long productId;
    private int selectedMode;
    private List<SoldoutCtrFood> soldoutCtrFoods;

    public LoadFineEvent(){

    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.currFinePage);
        dest.writeLong(this.productId);
        dest.writeInt(this.selectedMode);
        dest.writeList(this.soldoutCtrFoods);
    }

    public LoadFineEvent(Parcel in) {
        this.currFinePage = in.readInt();
        this.productId = in.readLong();
        this.selectedMode = in.readInt();
        this.soldoutCtrFoods = new ArrayList<SoldoutCtrFood>();
        in.readList(this.soldoutCtrFoods, SoldoutCtrFood.class.getClassLoader());
    }

    public static final Creator<LoadFineEvent> CREATOR = new Creator<LoadFineEvent>() {
        @Override
        public LoadFineEvent createFromParcel(Parcel source) {
            return new LoadFineEvent(source);
        }

        @Override
        public LoadFineEvent[] newArray(int size) {
            return new LoadFineEvent[size];
        }
    };
}
