package com.gingersoft.gsa.cloud.table.mvp.ui.activity.meal;

import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.widget.Button;
import android.widget.Chronometer;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.common.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.common.utils.VibratorUtils;
import com.gingersoft.gsa.cloud.order.order.BaseOrder;
import com.gingersoft.gsa.cloud.order.order.MealOrder;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.contract.BaseMealContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.event.InitTableEvent;
import com.gingersoft.gsa.cloud.table.mvp.presenter.mealstand.BaseMealPresenter;
import com.gingersoft.gsa.cloud.ui.widget.dialog.CommonTipDialog;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;

import org.simple.eventbus.EventBus;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/10/2021 11:36
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public abstract class BaseMealActivity<P extends BaseMealPresenter> extends BaseFragmentActivity<P> implements BaseMealContract.View {

    protected Chronometer ctime;
    protected Button btnTable;
    protected RecyclerView rvMealCart;
    protected RecyclerView rvBillDetail;

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        recordOperat(true);
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        ctime = findViewById(R.id.ctime);
        btnTable = findViewById(R.id.btn_table);
        rvMealCart = findViewById(R.id.rv_meal_cart);
        rvBillDetail = findViewById(R.id.rv_bill_detail);

        if (BaseOrder.isTableToMeal() && !MealOrder.getInstance().isModifyOrder()) {
            //根据倒计时时间自动退出当前页面
            initAutoQuit();
        }
        useMemberState();
    }

    protected void useMemberState(){
        if (MealOrder.getInstance().getMemberInfo() != null) {
            btnTable.setBackgroundResource(R.color.pink_300);
        }else {
            btnTable.setBackgroundColor(Color.parseColor("#336699"));
        }
    }

    @Override
    public void initIntent() {
    }

    @Override
    public void initTopBar() {
    }

    @Override
    public void initLanguage() {
    }

    @Override
    public void initLayoutParams() {
    }

    @Override
    public void initLayoutVisible() {
    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(mContext, message, true);
        else
            LoadingDialog.showDialogForLoading(mContext);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void setMealCartAdapter(DefaultAdapter adapter) {
        if (rvMealCart != null) {
            rvMealCart.setAdapter(adapter);
        }
    }

    @Override
    public void setBillDetailAdapter(DefaultAdapter adapter) {
        if (rvBillDetail != null) {
            rvBillDetail.setAdapter(adapter);
        }
    }

    @Override
    public void onBackPressedSupport() {
        returnTableActivity(true);
    }

    @Override
    public void initAutoQuit() {
        if (ctime == null) {
            return;
        }
        ctime.setBase(SystemClock.elapsedRealtime());
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.CUPCAKE) {
            ctime.setOnChronometerTickListener(new Chronometer.OnChronometerTickListener() {

                @Override
                public void onChronometerTick(Chronometer chronometer) {
                    // 执行一下看看是否按下了home键的线程
                    // 如果开始计时到现在超过了autoQuitTime秒
                    int autoQuitTime = GsaCloudApplication.functionConfiguration.getAutoQuitTimeVaule();
                    if (SystemClock.elapsedRealtime() - chronometer.getBase() > autoQuitTime * 1000) {
                        // 停止计时
                        chronometer.stop();
                        returnBeforeActivity(true);
                    }
                }
            });
        }
        //开启倒计时
        ctime.start();
    }

    @Override
    public void recordOperat(boolean isPressButtonSound) {
        if (ctime == null) {
            return;
        }
        if (isPressButtonSound) {
            VibratorUtils.pressButtonSound(this);
        }
        //关闭倒计时
        if (ctime != null) {
            ctime.stop();
        }
        //重新开启倒计时
        if (ctime != null) {
            ctime.setBase(SystemClock.elapsedRealtime());
            ctime.start();
        }
    }

    @Override
    public void returnTableActivity(boolean initTable) {
        if (mPresenter.hasNesOrderFoods()) {
            //没有过重复下单提示且有未送单食品，提示用户
            String tip = LanguageUtils.get_language_system("food.not.delivered.tip", "有食品未送單, 確認離開?");
            Class[] parameterTypes = {boolean.class};
            Object[] parameters = {initTable};
            CommonTipDialog.showSurpisedDialog(this, tip, BaseMealActivity.class, this,
                    "returnBeforeActivity", parameterTypes, parameters);
        } else {
            returnBeforeActivity(initTable);
        }
    }

    @Override
    public void returnBeforeActivity(boolean initTable) {
        if (BaseOrder.isTableToMeal() && initTable && !MealOrder.getInstance().isModifyOrder()) {
            TableBean.DataBean dataBean = MealOrder.getInstance().getOpenTableInfo();
            if (dataBean != null) {
                //通知更新餐台状态
                EventBus.getDefault().post(new InitTableEvent(dataBean.getId(), dataBean.getTableNumber()), "initTable_status_event");
            }
        }
        killMyself();
    }

}
