package com.gingersoft.gsa.cloud.table.mvp.ui.activity.table;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.common.service.IServiceManager;
import com.gingersoft.gsa.cloud.component.ComponentName;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerTableModeComponent;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.TableModeContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.table.TableModePresenter;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/08/2021 14:08
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class TableModeActivity extends BaseActivity<TableModePresenter> implements TableModeContract.View {

    @BindView(R2.id.topbar)
    QMUITopBar mTopBar;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerTableModeComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.meal_activity_table_mode; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
//        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
//        mTopBar.removeAllLeftViews();
//        mTopBar.addLeftBackImageButton().setOnClickListener(new View.OnClickListener() {
//
//            @Override
//            public void onClick(View v) {
//                killMyself();
//            }
//        });
//        QMUIAlphaImageButton rightButton = mTopBar.addRightImageButton(R.drawable.icon_refresh, R.id.btn_right);
//        QMUIAlphaImageButton rightButton2 = mTopBar.addRightImageButton(R.mipmap.meal_down, R.id.btn_fid);
//        rightButton.setOnClickListener(new View.OnClickListener() {
//
//            @Override
//            public void onClick(View v) {
//                LoganManager.w_tableMode(TAG, "手動刷新餐檯數據");
////                launchActivity(new Intent(mContext, CoordinatorlayoutActivity.class));
//                getTables(true, null);
//                IServiceManager.startICommandService(GsaCloudApplication.getAppContext());
//            }
//        });
//        rightButton2.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                CC.obtainBuilder(ComponentName.COMPONENT_DOWNLOAD)
//                        .setActionName("showDownloadActivity")
//                        .addParam("fromPage", 2)
//                        .build()
//                        .call();
//            }
//        });
//        mTopBar.setTitle("餐檯模式");
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }
}
