package com.gingersoft.gsa.cloud.common.utils.other;

import android.graphics.Typeface;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.widget.EditText;

import androidx.annotation.ColorInt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/7/5
 * 修订历史：2018/7/5
 * 描述：
 */

public class TextUtil {

    public static boolean isEmptyOrNullOrUndefined(String str) {
        return str == null || str.length() == 0 ||
                str.equals("null") || str.equals("undefined");
    }

    public static boolean isEmptyOrNullOrUndefined(CharSequence str) {
        return str == null || str.length() == 0 ||
                str.equals("null") || str.equals("undefined");
    }

    public static boolean isEmptyOrNullOrUndefined(EditText editText) {
        if (editText == null || editText.getText() == null) {
            return true;
        } else {
            return isEmptyOrNullOrUndefined(editText.getText().toString());
        }
    }

    public static boolean isNotEmptyOrNullOrUndefined(String str) {
        return str != null && str.length() != 0 &&
                !str.equals("null") && !str.equals("undefined");
    }

    public static boolean isNotEmptyOrNullOrUndefined(CharSequence str) {
        return str != null && str.length() != 0 &&
                !str.equals("null") && !str.equals("undefined");
    }

    public static boolean isNotEmptyOrNullOrUndefined(EditText editText) {
        if (editText != null && editText.getText() != null) {
            String str = editText.getText().toString();
            return str.length() != 0 && !str.equals("null") && !str.equals("undefined");
        } else {
            return false;
        }
    }

    public static String getNotNullStr(String str) {
        if (isEmptyOrNullOrUndefined(str)) {
            return "";
        }
        return str;
    }

    public static String getNotNullStrAndTrim(String str) {
        if (isEmptyOrNullOrUndefined(str)) {
            return "";
        }
        return str.trim();
    }

    public static String isEmptyReturnString(String str) {
        if (str == null || str.length() == 0 ||
                str.equals("null") || str.equals("undefined")) {
            return "";
        } else {
            return str;
        }
    }

    public static int isEmptyReturnInt(Integer str) {
        if (str == null) {
            return 0;
        } else {
            return str;
        }
    }

    /**
     * 半角转换为全角
     *
     * @param input
     * @return
     */
    public static String ToDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; i++) {
            if (c[i] == 12288) {
                c[i] = (char) 32;
                continue;
            }
            if (c[i] > 65280 && c[i] < 65375) {
                c[i] = (char) (c[i] - 65248);
            }
        }
        return new String(c);
    }

    /**
     * 去除特殊字符或将所有中文标号替换为英文标号
     *
     * @param str
     * @return
     */
    public static String stringFilter(String str) {
        // 替换中文标号
        str = str.replaceAll("【", "[").replaceAll("】", "]")
                .replaceAll("！", "!").replaceAll("：", ":");
        // 清除掉特殊字符
        String regEx = "[『』]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }


    /**
     * 判断是否中文
     * GENERAL_PUNCTUATION 判断中文的“号
     * CJK_SYMBOLS_AND_PUNCTUATION 判断中文的。号
     * HALFWIDTH_AND_FULLWIDTH_FORMS 判断中文的，号
     *
     * @param c 字符
     * @return 是否中文
     */
    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A
                || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B
                || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION
                || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS
                || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    /**
     * @return 獲取字符串長度，區分中英文
     */
    public static int getStringLength(String str) {
        if (isEmptyOrNullOrUndefined(str)) {
            return 0;
        }
        int length = 0;
        for (int i = 0; i < str.length(); i++) {
            length += isChinese(str.charAt(i)) ? 2 : 1;
        }
        return length;
    }

    public static SpannableString getSpannableString(CharSequence source, @ColorInt int color, int startIndex, int endIndex) {
        if (source != null) {
            if (endIndex > source.length()) {
                endIndex = source.length();
            }
            SpannableString spannableString = new SpannableString(source);
            ForegroundColorSpan colorSpan = new ForegroundColorSpan(color);
            spannableString.setSpan(colorSpan, startIndex, endIndex, Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
            return spannableString;
        }
        return null;
    }

    public static SpannableString getBoldSpannableString(CharSequence source, @ColorInt int color, int startIndex, int endIndex) {
        if (source != null) {
            if (endIndex > source.length()) {
                endIndex = source.length();
            }
            //AbsoluteSizeSpan(int size) ---- 设置字体大小，参数是绝对数值，相当于Word中的字体大小
            //RelativeSizeSpan(float proportion) ---- 设置字体大小，参数是相对于默认字体大小的倍数，比如默认字体大小是x, 那么设置后的字体大小就是x*proportion，这个用起来比较灵活，proportion>1就是放大(zoom in), proportion<1就是缩小(zoom out)
            //ScaleXSpan(float proportion) ---- 缩放字体，与上面的类似，默认为1,设置后就是原来的乘以proportion，大于1时放大(zoon in)，小于时缩小(zoom out)
            //BackgroundColorSpan(int color) ----背景着色，参数是颜色数值，可以直接使用android.graphics.Color里面定义的常量，或是用Color.rgb(int, int, int)
            //ForegroundColorSpan(int color) ----前景着色，也就是字的着色，参数与背景着色一致
            //TypefaceSpan(String family) ----字体，参数是字体的名字比如“sans", "sans-serif"等
            //StyleSpan(Typeface style) -----字体风格，比如粗体，斜体，参数是android.graphics.Typeface里面定义的常量，如Typeface.BOLD，Typeface.ITALIC等等。
            //StrikethroughSpan----如果设置了此风格，会有一条线从中间穿过所有的字，就像被划掉一样
            SpannableString spannableString = new SpannableString(source);
            ForegroundColorSpan colorSpan = new ForegroundColorSpan(color);
            StyleSpan styleSpan = new StyleSpan(Typeface.BOLD);
            //Spanned.SPAN_EXCLUSIVE_EXCLUSIVE --- 不包含两端start和end所在的端点
            //Spanned.SPAN_EXCLUSIVE_INCLUSIVE --- 不包含端start，但包含end所在的端点
            //Spanned.SPAN_INCLUSIVE_EXCLUSIVE --- 包含两端start，但不包含end所在的端点
            //Spanned.SPAN_INCLUSIVE_INCLUSIVE--- 包含两端start和end所在的端点
            spannableString.setSpan(styleSpan, startIndex, endIndex, Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
            spannableString.setSpan(colorSpan, startIndex, endIndex, Spanned.SPAN_INCLUSIVE_EXCLUSIVE);
            return spannableString;
        }
        return null;
    }


}
