package com.gingersoft.gsa.cloud.database.greendao;

import java.util.List;
import java.util.ArrayList;
import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.SqlUtils;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.ColorBean;

import com.gingersoft.gsa.cloud.database.bean.Modifier;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "MODIFIER".
*/
public class ModifierDao extends AbstractDao<Modifier, Long> {

    public static final String TABLENAME = "MODIFIER";

    /**
     * Properties of entity Modifier.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Dbid = new Property(0, Long.class, "dbid", true, "_id");
        public final static Property Mid = new Property(1, long.class, "mid", false, "MID");
        public final static Property TopId = new Property(2, long.class, "topId", false, "TOP_ID");
        public final static Property RestaurantId = new Property(3, long.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property ModifierName = new Property(4, String.class, "modifierName", false, "MODIFIER_NAME");
        public final static Property SeqNo = new Property(5, long.class, "seqNo", false, "SEQ_NO");
        public final static Property MarketPrice = new Property(6, double.class, "marketPrice", false, "MARKET_PRICE");
        public final static Property Price = new Property(7, double.class, "price", false, "PRICE");
        public final static Property LunchboxPrice = new Property(8, double.class, "lunchboxPrice", false, "LUNCHBOX_PRICE");
        public final static Property ImageUrl = new Property(9, String.class, "imageUrl", false, "IMAGE_URL");
        public final static Property Invisible = new Property(10, long.class, "invisible", false, "INVISIBLE");
        public final static Property Cost = new Property(11, double.class, "cost", false, "COST");
        public final static Property StartDate = new Property(12, java.util.Date.class, "startDate", false, "START_DATE");
        public final static Property EndDate = new Property(13, java.util.Date.class, "endDate", false, "END_DATE");
        public final static Property Like = new Property(14, long.class, "like", false, "LIKE");
        public final static Property TotalSold = new Property(15, long.class, "totalSold", false, "TOTAL_SOLD");
        public final static Property MajorMainId = new Property(16, long.class, "majorMainId", false, "MAJOR_MAIN_ID");
        public final static Property DeptId = new Property(17, long.class, "deptId", false, "DEPT_ID");
        public final static Property CreateBy = new Property(18, String.class, "createBy", false, "CREATE_BY");
        public final static Property CreateTime = new Property(19, java.util.Date.class, "createTime", false, "CREATE_TIME");
        public final static Property UpdateBy = new Property(20, String.class, "updateBy", false, "UPDATE_BY");
        public final static Property UpdateTime = new Property(21, java.util.Date.class, "updateTime", false, "UPDATE_TIME");
        public final static Property PosFid = new Property(22, String.class, "posFid", false, "POS_FID");
        public final static Property PId = new Property(23, String.class, "pId", false, "P_ID");
        public final static Property AutoMod = new Property(24, long.class, "autoMod", false, "AUTO_MOD");
        public final static Property BlueEdit = new Property(25, long.class, "blueEdit", false, "BLUE_EDIT");
        public final static Property AutoMerge = new Property(26, long.class, "autoMerge", false, "AUTO_MERGE");
        public final static Property CustomMsg = new Property(27, long.class, "customMsg", false, "CUSTOM_MSG");
        public final static Property IsParent = new Property(28, long.class, "isParent", false, "IS_PARENT");
        public final static Property ModifierName1 = new Property(29, String.class, "modifierName1", false, "MODIFIER_NAME1");
        public final static Property ModifierName2 = new Property(30, String.class, "modifierName2", false, "MODIFIER_NAME2");
        public final static Property Multiple = new Property(31, double.class, "multiple", false, "MULTIPLE");
        public final static Property PrintSet = new Property(32, String.class, "printSet", false, "PRINT_SET");
        public final static Property KtSetting = new Property(33, String.class, "ktSetting", false, "KT_SETTING");
        public final static Property ModComm = new Property(34, long.class, "modComm", false, "MOD_COMM");
        public final static Property ModTaste = new Property(35, long.class, "modTaste", false, "MOD_TASTE");
        public final static Property ModMsg = new Property(36, long.class, "modMsg", false, "MOD_MSG");
        public final static Property KtFireCourse = new Property(37, long.class, "ktFireCourse", false, "KT_FIRE_COURSE");
        public final static Property AbleDisCount = new Property(38, long.class, "ableDisCount", false, "ABLE_DIS_COUNT");
        public final static Property PrintToBill = new Property(39, long.class, "printToBill", false, "PRINT_TO_BILL");
        public final static Property KtPrintMainItem = new Property(40, long.class, "ktPrintMainItem", false, "KT_PRINT_MAIN_ITEM");
        public final static Property KtShowPrice = new Property(41, long.class, "ktShowPrice", false, "KT_SHOW_PRICE");
        public final static Property KtFont = new Property(42, long.class, "ktFont", false, "KT_FONT");
        public final static Property Conditions = new Property(43, long.class, "conditions", false, "CONDITIONS");
        public final static Property IsRt = new Property(44, long.class, "isRt", false, "IS_RT");
        public final static Property Visible = new Property(45, byte.class, "visible", false, "VISIBLE");
        public final static Property Deletes = new Property(46, long.class, "deletes", false, "DELETES");
        public final static Property IsStatistic = new Property(47, long.class, "isStatistic", false, "IS_STATISTIC");
        public final static Property ColorId = new Property(48, long.class, "colorId", false, "COLOR_ID");
    }

    private DaoSession daoSession;


    public ModifierDao(DaoConfig config) {
        super(config);
    }
    
    public ModifierDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
        this.daoSession = daoSession;
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"MODIFIER\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: dbid
                "\"MID\" INTEGER NOT NULL ," + // 1: mid
                "\"TOP_ID\" INTEGER NOT NULL ," + // 2: topId
                "\"RESTAURANT_ID\" INTEGER NOT NULL ," + // 3: restaurantId
                "\"MODIFIER_NAME\" TEXT," + // 4: modifierName
                "\"SEQ_NO\" INTEGER NOT NULL ," + // 5: seqNo
                "\"MARKET_PRICE\" REAL NOT NULL ," + // 6: marketPrice
                "\"PRICE\" REAL NOT NULL ," + // 7: price
                "\"LUNCHBOX_PRICE\" REAL NOT NULL ," + // 8: lunchboxPrice
                "\"IMAGE_URL\" TEXT," + // 9: imageUrl
                "\"INVISIBLE\" INTEGER NOT NULL ," + // 10: invisible
                "\"COST\" REAL NOT NULL ," + // 11: cost
                "\"START_DATE\" INTEGER," + // 12: startDate
                "\"END_DATE\" INTEGER," + // 13: endDate
                "\"LIKE\" INTEGER NOT NULL ," + // 14: like
                "\"TOTAL_SOLD\" INTEGER NOT NULL ," + // 15: totalSold
                "\"MAJOR_MAIN_ID\" INTEGER NOT NULL ," + // 16: majorMainId
                "\"DEPT_ID\" INTEGER NOT NULL ," + // 17: deptId
                "\"CREATE_BY\" TEXT," + // 18: createBy
                "\"CREATE_TIME\" INTEGER," + // 19: createTime
                "\"UPDATE_BY\" TEXT," + // 20: updateBy
                "\"UPDATE_TIME\" INTEGER," + // 21: updateTime
                "\"POS_FID\" TEXT," + // 22: posFid
                "\"P_ID\" TEXT," + // 23: pId
                "\"AUTO_MOD\" INTEGER NOT NULL ," + // 24: autoMod
                "\"BLUE_EDIT\" INTEGER NOT NULL ," + // 25: blueEdit
                "\"AUTO_MERGE\" INTEGER NOT NULL ," + // 26: autoMerge
                "\"CUSTOM_MSG\" INTEGER NOT NULL ," + // 27: customMsg
                "\"IS_PARENT\" INTEGER NOT NULL ," + // 28: isParent
                "\"MODIFIER_NAME1\" TEXT," + // 29: modifierName1
                "\"MODIFIER_NAME2\" TEXT," + // 30: modifierName2
                "\"MULTIPLE\" REAL NOT NULL ," + // 31: multiple
                "\"PRINT_SET\" TEXT," + // 32: printSet
                "\"KT_SETTING\" TEXT," + // 33: ktSetting
                "\"MOD_COMM\" INTEGER NOT NULL ," + // 34: modComm
                "\"MOD_TASTE\" INTEGER NOT NULL ," + // 35: modTaste
                "\"MOD_MSG\" INTEGER NOT NULL ," + // 36: modMsg
                "\"KT_FIRE_COURSE\" INTEGER NOT NULL ," + // 37: ktFireCourse
                "\"ABLE_DIS_COUNT\" INTEGER NOT NULL ," + // 38: ableDisCount
                "\"PRINT_TO_BILL\" INTEGER NOT NULL ," + // 39: printToBill
                "\"KT_PRINT_MAIN_ITEM\" INTEGER NOT NULL ," + // 40: ktPrintMainItem
                "\"KT_SHOW_PRICE\" INTEGER NOT NULL ," + // 41: ktShowPrice
                "\"KT_FONT\" INTEGER NOT NULL ," + // 42: ktFont
                "\"CONDITIONS\" INTEGER NOT NULL ," + // 43: conditions
                "\"IS_RT\" INTEGER NOT NULL ," + // 44: isRt
                "\"VISIBLE\" INTEGER NOT NULL ," + // 45: visible
                "\"DELETES\" INTEGER NOT NULL ," + // 46: deletes
                "\"IS_STATISTIC\" INTEGER NOT NULL ," + // 47: isStatistic
                "\"COLOR_ID\" INTEGER NOT NULL );"); // 48: colorId
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"MODIFIER\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Modifier entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
        stmt.bindLong(2, entity.getMid());
        stmt.bindLong(3, entity.getTopId());
        stmt.bindLong(4, entity.getRestaurantId());
 
        String modifierName = entity.getModifierName();
        if (modifierName != null) {
            stmt.bindString(5, modifierName);
        }
        stmt.bindLong(6, entity.getSeqNo());
        stmt.bindDouble(7, entity.getMarketPrice());
        stmt.bindDouble(8, entity.getPrice());
        stmt.bindDouble(9, entity.getLunchboxPrice());
 
        String imageUrl = entity.getImageUrl();
        if (imageUrl != null) {
            stmt.bindString(10, imageUrl);
        }
        stmt.bindLong(11, entity.getInvisible());
        stmt.bindDouble(12, entity.getCost());
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(13, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(14, endDate.getTime());
        }
        stmt.bindLong(15, entity.getLike());
        stmt.bindLong(16, entity.getTotalSold());
        stmt.bindLong(17, entity.getMajorMainId());
        stmt.bindLong(18, entity.getDeptId());
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(19, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(20, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(21, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(22, updateTime.getTime());
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(23, posFid);
        }
 
        String pId = entity.getPId();
        if (pId != null) {
            stmt.bindString(24, pId);
        }
        stmt.bindLong(25, entity.getAutoMod());
        stmt.bindLong(26, entity.getBlueEdit());
        stmt.bindLong(27, entity.getAutoMerge());
        stmt.bindLong(28, entity.getCustomMsg());
        stmt.bindLong(29, entity.getIsParent());
 
        String modifierName1 = entity.getModifierName1();
        if (modifierName1 != null) {
            stmt.bindString(30, modifierName1);
        }
 
        String modifierName2 = entity.getModifierName2();
        if (modifierName2 != null) {
            stmt.bindString(31, modifierName2);
        }
        stmt.bindDouble(32, entity.getMultiple());
 
        String printSet = entity.getPrintSet();
        if (printSet != null) {
            stmt.bindString(33, printSet);
        }
 
        String ktSetting = entity.getKtSetting();
        if (ktSetting != null) {
            stmt.bindString(34, ktSetting);
        }
        stmt.bindLong(35, entity.getModComm());
        stmt.bindLong(36, entity.getModTaste());
        stmt.bindLong(37, entity.getModMsg());
        stmt.bindLong(38, entity.getKtFireCourse());
        stmt.bindLong(39, entity.getAbleDisCount());
        stmt.bindLong(40, entity.getPrintToBill());
        stmt.bindLong(41, entity.getKtPrintMainItem());
        stmt.bindLong(42, entity.getKtShowPrice());
        stmt.bindLong(43, entity.getKtFont());
        stmt.bindLong(44, entity.getConditions());
        stmt.bindLong(45, entity.getIsRt());
        stmt.bindLong(46, entity.getVisible());
        stmt.bindLong(47, entity.getDeletes());
        stmt.bindLong(48, entity.getIsStatistic());
        stmt.bindLong(49, entity.getColorId());
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Modifier entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
        stmt.bindLong(2, entity.getMid());
        stmt.bindLong(3, entity.getTopId());
        stmt.bindLong(4, entity.getRestaurantId());
 
        String modifierName = entity.getModifierName();
        if (modifierName != null) {
            stmt.bindString(5, modifierName);
        }
        stmt.bindLong(6, entity.getSeqNo());
        stmt.bindDouble(7, entity.getMarketPrice());
        stmt.bindDouble(8, entity.getPrice());
        stmt.bindDouble(9, entity.getLunchboxPrice());
 
        String imageUrl = entity.getImageUrl();
        if (imageUrl != null) {
            stmt.bindString(10, imageUrl);
        }
        stmt.bindLong(11, entity.getInvisible());
        stmt.bindDouble(12, entity.getCost());
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(13, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(14, endDate.getTime());
        }
        stmt.bindLong(15, entity.getLike());
        stmt.bindLong(16, entity.getTotalSold());
        stmt.bindLong(17, entity.getMajorMainId());
        stmt.bindLong(18, entity.getDeptId());
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(19, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(20, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(21, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(22, updateTime.getTime());
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(23, posFid);
        }
 
        String pId = entity.getPId();
        if (pId != null) {
            stmt.bindString(24, pId);
        }
        stmt.bindLong(25, entity.getAutoMod());
        stmt.bindLong(26, entity.getBlueEdit());
        stmt.bindLong(27, entity.getAutoMerge());
        stmt.bindLong(28, entity.getCustomMsg());
        stmt.bindLong(29, entity.getIsParent());
 
        String modifierName1 = entity.getModifierName1();
        if (modifierName1 != null) {
            stmt.bindString(30, modifierName1);
        }
 
        String modifierName2 = entity.getModifierName2();
        if (modifierName2 != null) {
            stmt.bindString(31, modifierName2);
        }
        stmt.bindDouble(32, entity.getMultiple());
 
        String printSet = entity.getPrintSet();
        if (printSet != null) {
            stmt.bindString(33, printSet);
        }
 
        String ktSetting = entity.getKtSetting();
        if (ktSetting != null) {
            stmt.bindString(34, ktSetting);
        }
        stmt.bindLong(35, entity.getModComm());
        stmt.bindLong(36, entity.getModTaste());
        stmt.bindLong(37, entity.getModMsg());
        stmt.bindLong(38, entity.getKtFireCourse());
        stmt.bindLong(39, entity.getAbleDisCount());
        stmt.bindLong(40, entity.getPrintToBill());
        stmt.bindLong(41, entity.getKtPrintMainItem());
        stmt.bindLong(42, entity.getKtShowPrice());
        stmt.bindLong(43, entity.getKtFont());
        stmt.bindLong(44, entity.getConditions());
        stmt.bindLong(45, entity.getIsRt());
        stmt.bindLong(46, entity.getVisible());
        stmt.bindLong(47, entity.getDeletes());
        stmt.bindLong(48, entity.getIsStatistic());
        stmt.bindLong(49, entity.getColorId());
    }

    @Override
    protected final void attachEntity(Modifier entity) {
        super.attachEntity(entity);
        entity.__setDaoSession(daoSession);
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Modifier readEntity(Cursor cursor, int offset) {
        Modifier entity = new Modifier( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // dbid
            cursor.getLong(offset + 1), // mid
            cursor.getLong(offset + 2), // topId
            cursor.getLong(offset + 3), // restaurantId
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // modifierName
            cursor.getLong(offset + 5), // seqNo
            cursor.getDouble(offset + 6), // marketPrice
            cursor.getDouble(offset + 7), // price
            cursor.getDouble(offset + 8), // lunchboxPrice
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9), // imageUrl
            cursor.getLong(offset + 10), // invisible
            cursor.getDouble(offset + 11), // cost
            cursor.isNull(offset + 12) ? null : new java.util.Date(cursor.getLong(offset + 12)), // startDate
            cursor.isNull(offset + 13) ? null : new java.util.Date(cursor.getLong(offset + 13)), // endDate
            cursor.getLong(offset + 14), // like
            cursor.getLong(offset + 15), // totalSold
            cursor.getLong(offset + 16), // majorMainId
            cursor.getLong(offset + 17), // deptId
            cursor.isNull(offset + 18) ? null : cursor.getString(offset + 18), // createBy
            cursor.isNull(offset + 19) ? null : new java.util.Date(cursor.getLong(offset + 19)), // createTime
            cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20), // updateBy
            cursor.isNull(offset + 21) ? null : new java.util.Date(cursor.getLong(offset + 21)), // updateTime
            cursor.isNull(offset + 22) ? null : cursor.getString(offset + 22), // posFid
            cursor.isNull(offset + 23) ? null : cursor.getString(offset + 23), // pId
            cursor.getLong(offset + 24), // autoMod
            cursor.getLong(offset + 25), // blueEdit
            cursor.getLong(offset + 26), // autoMerge
            cursor.getLong(offset + 27), // customMsg
            cursor.getLong(offset + 28), // isParent
            cursor.isNull(offset + 29) ? null : cursor.getString(offset + 29), // modifierName1
            cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30), // modifierName2
            cursor.getDouble(offset + 31), // multiple
            cursor.isNull(offset + 32) ? null : cursor.getString(offset + 32), // printSet
            cursor.isNull(offset + 33) ? null : cursor.getString(offset + 33), // ktSetting
            cursor.getLong(offset + 34), // modComm
            cursor.getLong(offset + 35), // modTaste
            cursor.getLong(offset + 36), // modMsg
            cursor.getLong(offset + 37), // ktFireCourse
            cursor.getLong(offset + 38), // ableDisCount
            cursor.getLong(offset + 39), // printToBill
            cursor.getLong(offset + 40), // ktPrintMainItem
            cursor.getLong(offset + 41), // ktShowPrice
            cursor.getLong(offset + 42), // ktFont
            cursor.getLong(offset + 43), // conditions
            cursor.getLong(offset + 44), // isRt
            (byte) cursor.getShort(offset + 45), // visible
            cursor.getLong(offset + 46), // deletes
            cursor.getLong(offset + 47), // isStatistic
            cursor.getLong(offset + 48) // colorId
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Modifier entity, int offset) {
        entity.setDbid(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setMid(cursor.getLong(offset + 1));
        entity.setTopId(cursor.getLong(offset + 2));
        entity.setRestaurantId(cursor.getLong(offset + 3));
        entity.setModifierName(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setSeqNo(cursor.getLong(offset + 5));
        entity.setMarketPrice(cursor.getDouble(offset + 6));
        entity.setPrice(cursor.getDouble(offset + 7));
        entity.setLunchboxPrice(cursor.getDouble(offset + 8));
        entity.setImageUrl(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
        entity.setInvisible(cursor.getLong(offset + 10));
        entity.setCost(cursor.getDouble(offset + 11));
        entity.setStartDate(cursor.isNull(offset + 12) ? null : new java.util.Date(cursor.getLong(offset + 12)));
        entity.setEndDate(cursor.isNull(offset + 13) ? null : new java.util.Date(cursor.getLong(offset + 13)));
        entity.setLike(cursor.getLong(offset + 14));
        entity.setTotalSold(cursor.getLong(offset + 15));
        entity.setMajorMainId(cursor.getLong(offset + 16));
        entity.setDeptId(cursor.getLong(offset + 17));
        entity.setCreateBy(cursor.isNull(offset + 18) ? null : cursor.getString(offset + 18));
        entity.setCreateTime(cursor.isNull(offset + 19) ? null : new java.util.Date(cursor.getLong(offset + 19)));
        entity.setUpdateBy(cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20));
        entity.setUpdateTime(cursor.isNull(offset + 21) ? null : new java.util.Date(cursor.getLong(offset + 21)));
        entity.setPosFid(cursor.isNull(offset + 22) ? null : cursor.getString(offset + 22));
        entity.setPId(cursor.isNull(offset + 23) ? null : cursor.getString(offset + 23));
        entity.setAutoMod(cursor.getLong(offset + 24));
        entity.setBlueEdit(cursor.getLong(offset + 25));
        entity.setAutoMerge(cursor.getLong(offset + 26));
        entity.setCustomMsg(cursor.getLong(offset + 27));
        entity.setIsParent(cursor.getLong(offset + 28));
        entity.setModifierName1(cursor.isNull(offset + 29) ? null : cursor.getString(offset + 29));
        entity.setModifierName2(cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30));
        entity.setMultiple(cursor.getDouble(offset + 31));
        entity.setPrintSet(cursor.isNull(offset + 32) ? null : cursor.getString(offset + 32));
        entity.setKtSetting(cursor.isNull(offset + 33) ? null : cursor.getString(offset + 33));
        entity.setModComm(cursor.getLong(offset + 34));
        entity.setModTaste(cursor.getLong(offset + 35));
        entity.setModMsg(cursor.getLong(offset + 36));
        entity.setKtFireCourse(cursor.getLong(offset + 37));
        entity.setAbleDisCount(cursor.getLong(offset + 38));
        entity.setPrintToBill(cursor.getLong(offset + 39));
        entity.setKtPrintMainItem(cursor.getLong(offset + 40));
        entity.setKtShowPrice(cursor.getLong(offset + 41));
        entity.setKtFont(cursor.getLong(offset + 42));
        entity.setConditions(cursor.getLong(offset + 43));
        entity.setIsRt(cursor.getLong(offset + 44));
        entity.setVisible((byte) cursor.getShort(offset + 45));
        entity.setDeletes(cursor.getLong(offset + 46));
        entity.setIsStatistic(cursor.getLong(offset + 47));
        entity.setColorId(cursor.getLong(offset + 48));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Modifier entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Modifier entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Modifier entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
    private String selectDeep;

    protected String getSelectDeep() {
        if (selectDeep == null) {
            StringBuilder builder = new StringBuilder("SELECT ");
            SqlUtils.appendColumns(builder, "T", getAllColumns());
            builder.append(',');
            SqlUtils.appendColumns(builder, "T0", daoSession.getColorBeanDao().getAllColumns());
            builder.append(" FROM MODIFIER T");
            builder.append(" LEFT JOIN COLOR_BEAN T0 ON T.\"COLOR_ID\"=T0.\"_id\"");
            builder.append(' ');
            selectDeep = builder.toString();
        }
        return selectDeep;
    }
    
    protected Modifier loadCurrentDeep(Cursor cursor, boolean lock) {
        Modifier entity = loadCurrent(cursor, 0, lock);
        int offset = getAllColumns().length;

        ColorBean colorBean = loadCurrentOther(daoSession.getColorBeanDao(), cursor, offset);
         if(colorBean != null) {
            entity.setColorBean(colorBean);
        }

        return entity;    
    }

    public Modifier loadDeep(Long key) {
        assertSinglePk();
        if (key == null) {
            return null;
        }

        StringBuilder builder = new StringBuilder(getSelectDeep());
        builder.append("WHERE ");
        SqlUtils.appendColumnsEqValue(builder, "T", getPkColumns());
        String sql = builder.toString();
        
        String[] keyArray = new String[] { key.toString() };
        Cursor cursor = db.rawQuery(sql, keyArray);
        
        try {
            boolean available = cursor.moveToFirst();
            if (!available) {
                return null;
            } else if (!cursor.isLast()) {
                throw new IllegalStateException("Expected unique result, but count was " + cursor.getCount());
            }
            return loadCurrentDeep(cursor, true);
        } finally {
            cursor.close();
        }
    }
    
    /** Reads all available rows from the given cursor and returns a list of new ImageTO objects. */
    public List<Modifier> loadAllDeepFromCursor(Cursor cursor) {
        int count = cursor.getCount();
        List<Modifier> list = new ArrayList<Modifier>(count);
        
        if (cursor.moveToFirst()) {
            if (identityScope != null) {
                identityScope.lock();
                identityScope.reserveRoom(count);
            }
            try {
                do {
                    list.add(loadCurrentDeep(cursor, false));
                } while (cursor.moveToNext());
            } finally {
                if (identityScope != null) {
                    identityScope.unlock();
                }
            }
        }
        return list;
    }
    
    protected List<Modifier> loadDeepAllAndCloseCursor(Cursor cursor) {
        try {
            return loadAllDeepFromCursor(cursor);
        } finally {
            cursor.close();
        }
    }
    

    /** A raw-style query where you can pass any WHERE clause and arguments. */
    public List<Modifier> queryDeep(String where, String... selectionArg) {
        Cursor cursor = db.rawQuery(getSelectDeep() + where, selectionArg);
        return loadDeepAllAndCloseCursor(cursor);
    }
 
}
