package com.gingersoft.gsa.cloud.common.ui.adapter;

import android.widget.RadioButton;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/21
 * Time: 17:41
 * Use:
 */
public class RadioPicListAdapter extends BaseQuickAdapter<RadioPicListAdapter.RadioPicBean, BaseViewHolder> {

    private int selectIndex = 0;

    public RadioPicListAdapter(@Nullable List<RadioPicBean> data) {
        super(R.layout.item_pic_radio, data);
    }

    public RadioPicListAdapter(int layoutId, @Nullable List<RadioPicBean> data) {
        super(layoutId, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, RadioPicBean item) {
        RadioButton radioButton = viewHolder.getView(R.id.rb_select_dialog_list_radio);
        radioButton.setChecked(viewHolder.getAdapterPosition() == selectIndex);
        viewHolder.setText(R.id.tv_select_dialog_list_title, item.title);
        viewHolder.setImageResource(R.id.iv_item_pic_radio_pic, item.picResources);
        radioButton.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (isChecked) {
                setSelectIndex(viewHolder.getAdapterPosition());
            }
        });
    }

    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
        notifyDataSetChanged();
    }

    public int getSelectIndex() {
        return selectIndex;
    }

    public static class RadioPicBean {
        private String title;
        private int picResources;

        public RadioPicBean(String title, int picResources) {
            this.title = title;
            this.picResources = picResources;
        }
    }
}
