package com.gingersoft.gsa.cloud.download.mvp.model;

import android.app.Application;
import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.ComboItemRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.FoodComboRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.FoodModifierRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.FunctionRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.ModifierRespone;
import com.gingersoft.gsa.cloud.download.mvp.model.service.DownloadService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;
import com.jess.arms.di.scope.ActivityScope;
import javax.inject.Inject;
import com.gingersoft.gsa.cloud.download.mvp.contract.DownloadContract;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/26/2019 17:59
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class DownloadModel extends BaseModel implements DownloadContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public DownloadModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
        RetrofitUrlManager.getInstance().putDomain("common", HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> downFunctionList(long userId) {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downFunctionList(userId);
    }

    @Override
    public Observable<BaseResult> downFoodList(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downFoodList(restaurantId);
    }

    @Override
    public Observable<BaseResult> downModifier(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downModifier(restaurantId);
    }

    @Override
    public Observable<BaseResult> downFoodCombo(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downFoodCombo(restaurantId);
    }

    @Override
    public Observable<BaseResult> downComboItem(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downComboItem(restaurantId);
    }

    @Override
    public Observable<BaseResult> downFoodModifier(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downFoodModifier(restaurantId);
    }

    @Override
    public Observable<BaseResult> downDiscount(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downDiscount(restaurantId);
    }

    @Override
    public Observable<BaseResult> downExpandInfo(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downExpandInfo(restaurantId);
    }

    @Override
    public Observable<BaseResult> downPrinterList(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downPrinterList(restaurantId);
    }

    @Override
    public Observable<BaseResult> downColorList() {
        return mRepositoryManager.obtainRetrofitService(DownloadService.class)
                .downColorList();
    }


}