package com.gingersoft.gsa.cloud.download.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.billy.cc.core.component.CC;
import com.billy.cc.core.component.CCUtil;
import com.gingersoft.gsa.cloud.common.constans.ResultConstans;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.component.ComponentName;
import com.gingersoft.gsa.cloud.download.R;
import com.gingersoft.gsa.cloud.download.R2;
import com.gingersoft.gsa.cloud.download.di.component.DaggerDownloadComponent;
import com.gingersoft.gsa.cloud.download.mvp.contract.DownloadContract;
import com.gingersoft.gsa.cloud.download.mvp.presenter.DownloadPresenter;
import com.gingersoft.gsa.cloud.ui.view.WaveHelper;
import com.gingersoft.gsa.cloud.ui.view.WaveView;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.gyf.immersionbar.ImmersionBar;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/26/2019 17:59
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class DownloadActivity extends BaseActivity<DownloadPresenter> implements DownloadContract.View {

    @BindView(R2.id.btn_back)
    ImageButton btn_back;
    @BindView(R2.id.btn_refresh)
    ImageButton btn_refresh;
    @BindView(R2.id.tv_title)
    TextView tv_title;
    @BindView(R2.id.recycle_download)
    RecyclerView recycle_download;

    @BindView(R2.id.tv_progress)
    TextView tv_progress;
    @BindView(R2.id.wave_download)
    WaveView waveView;
    @BindView(R2.id.layout_download_title)
    RelativeLayout layoutTitle;
    private WaveHelper mWaveHelper;
    /**
     * 那個頁面跳轉下載
     * 1#登錄頁選擇餐廳
     * 2#其他
     */
    private int fromPage = 1;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerDownloadComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.download_data_activity_download; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        mWaveHelper = new WaveHelper(waveView);

        mPresenter.initAdapter();
        mPresenter.downAllList();
    }

    @Override
    public void configImmersionBar(ImmersionBar immersionBar) {
        immersionBar
                .transparentBar()
                .titleBarMarginTop(layoutTitle)
                .init();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (mWaveHelper != null)
            mWaveHelper.start();
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (mWaveHelper != null)
            mWaveHelper.cancel();
    }

//    @Override
//    protected void doOnBackPressed() {
//        if (fromPage == 1) {
//            CC.obtainBuilder(ComponentName.COMPONENT_MAIN)
//                    .setActionName("showMainActivity")
//                    .build()
//                    .call();
//        }
//        killMyself();
//    }


    @Override
    public void onBackPressed() {
        if (fromPage == 1) {
            CC.obtainBuilder(ComponentName.COMPONENT_MAIN)
                    .setActionName("showMainActivity")
                    .build()
                    .call();
        } else {
            setResult(ResultConstans.DOWNLOAD_PAGE_BACK);
        }
        finish();
    }

    @Override
    public void initIntent() {
        fromPage = CCUtil.getNavigateParam(this, "fromPage", 1);
    }

    @Override
    public void initTopBar() {
        tv_title.setText("數據下載");
        btn_back.setOnClickListener(v -> {
            onBackPressed();
        });
        btn_refresh.setOnClickListener(v -> mPresenter.downAllList());
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ToastUtils.show(mContext, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        onBackPressed();
    }

    @Override
    public RecyclerView getRecycleDownload() {
        return recycle_download;
    }

    @Override
    public void setDownLoadListAdapter(DefaultAdapter adapter) {
        recycle_download.setAdapter(adapter);
        initDownLoadRecycleView();
    }

    private void initDownLoadRecycleView() {
        LinearLayoutManager manager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
        ArmsUtils.configRecyclerView(recycle_download, manager);
    }

    public void setTvProgress(float progress) {
        tv_progress.setText(progress + "%");
    }


    public int getFromPage() {
        return fromPage;
    }

}
