package com.gingersoft.gsa.cloud.main.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.main.di.module.LiquidationHistoryModule;
import com.gingersoft.gsa.cloud.main.mvp.contract.LiquidationHistoryContract;

import com.jess.arms.di.scope.ActivityScope;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.LiquidationHistoryActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/26/2021 17:45
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = LiquidationHistoryModule.class, dependencies = AppComponent.class)
public interface LiquidationHistoryComponent {
    void inject(LiquidationHistoryActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        LiquidationHistoryComponent.Builder view(LiquidationHistoryContract.View view);

        LiquidationHistoryComponent.Builder appComponent(AppComponent appComponent);

        LiquidationHistoryComponent build();
    }
}