package com.gingersoft.gsa.cloud.main.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.main.mvp.model.service.SettlementService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.ActivityScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.main.mvp.contract.LiquidationHistoryContract;

import java.util.Map;

import io.reactivex.Observable;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 05/26/2021 17:45
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class LiquidationHistoryModel extends BaseModel implements LiquidationHistoryContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public LiquidationHistoryModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> getLiquidationHistory(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SettlementService.class).getLiquidationHistory(map);
    }

    @Override
    public Observable<BaseResult> getSettlementReport(int restaurantId, String startTime, String endTime) {
        return mRepositoryManager.obtainRetrofitService(SettlementService.class).getSettlementReport(restaurantId, startTime, endTime);
    }
}
