package com.gingersoft.gsa.cloud.main.mvp.model.service;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SendSettlement;

import java.util.Map;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-05
 * 修订历史：2020-03-05
 * 描述：
 */
public interface SettlementService {

    @POST("RestaurantOperation/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<SendSettlement> sendSettlement(@Body RequestBody requestBody);

    @Headers({"Domain-Name: settlement_report_server"})
    @GET("restaurantOperation/report" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getSettlementReport(@Query("restaurantId") int restaurantId, @Query("startTime") String startTime, @Query("endTime") String endTIme);

    @POST("posPay/addOperation" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addHywebPosSettlementOperation();

    @POST("posPay/updateOperation" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateHywebPosSettlementOperation(@Body RequestBody requestBody);

    @Headers({"Domain-Name: settlement_report_server"})
    @GET("restaurantOperation/getHistoryCleaner" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getLiquidationHistory(@QueryMap Map<String, Object> map);

}
