package com.gingersoft.gsa.cloud.main.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

import com.gingersoft.gsa.cloud.common.core.settlement.SettlementReport;
import com.gingersoft.gsa.cloud.common.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerSettlementComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.SettlementContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.SettlementPresenter;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * Description: 清機頁面
 *
 * @author admin
 */
public class SettlementActivity extends BaseActivity<SettlementPresenter> implements SettlementContract.View {

    @BindView(R2.id.topbar)
    QMUITopBar mTopBar;

    @BindView(R2.id.tv_settlement_time)
    TextView tv_settlement_time;
    @BindView(R2.id.btn_settlement_report)
    QMUIAlphaButton btn_settlement_report;

    private SettlementReport mSettlementReportBean;

    private int mSettlementType;
    public static final String SETTLEMENT_TYPE_TAG = "settlement_type";
    /**
     * 普通清機
     */
    public static final int SETTLEMENT_TYPE_NOMAL = 1;
    /**
     * N5清機
     */
    public static final int SETTLEMENT_TYPE_HYWEB_POS = 2;
    /**
     * 線下清機
     */
    public static final int OFFLINE_SETTLEMENT = 3;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerSettlementComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_settlement; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        mPresenter.getSettlementReport(mSettlementType);
    }

    @Override
    public void initIntent() {
        Intent intent = getIntent();
        mSettlementType = intent.getIntExtra(SETTLEMENT_TYPE_TAG, SETTLEMENT_TYPE_NOMAL);
    }

    @Override
    public void initTopBar() {
        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        mTopBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        mTopBar.addRightTextButton(R.string.str_history_record, R.id.mainId_history_record).setOnClickListener(v -> {
            //清機歷史
            Intent intent = new Intent(mContext, LiquidationHistoryActivity.class);
            intent.putExtra(SettlementActivity.SETTLEMENT_TYPE_TAG, mSettlementType);
            startActivity(intent);
        });
        mTopBar.setTitle(LanguageUtils.get_language_system("funcSelect.settlement", "清機")).setTextColor(ArmsUtils.getColor(this, R.color.theme_white_color));
    }

    @OnClick({R2.id.btn_settlement_report})
    public void onClick(View v) {
        if (v.getId() == R.id.btn_settlement_report) {
            Intent intent = new Intent(this, SettlementReportActivity.class);
            intent.putExtra("settlementReportBean", mSettlementReportBean);
            intent.putExtra(SETTLEMENT_TYPE_TAG, mSettlementType);
            launchActivity(intent);
            mSettlementReportBean = null;
        }
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void setLastTime(String date) {
        tv_settlement_time.setText(date);
    }

    @Override
    public void returnSettlementData(SettlementReport datasBean) {
        this.mSettlementReportBean = datasBean;
        if (mSettlementReportBean.getRestaurantOperation() != null) {
            String lastSettlementText = LanguageUtils.get_language_system("", "上次清機時間:");
            setLastTime(lastSettlementText + TimeUtils.getStringByFormat(mSettlementReportBean.getRestaurantOperation().getOperationTime(), TimeUtils.DEFAULT_DATE_FORMAT));
        }
    }


}
