package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.Switch;
import android.widget.TextView;

import com.bigkoo.pickerview.builder.TimePickerBuilder;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.ExpandInfo;
import com.gingersoft.gsa.cloud.main.R;

import org.jetbrains.annotations.NotNull;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;

public class ExpandListAdapter extends BaseQuickAdapter<ExpandInfo, BaseViewHolder> {


    public ExpandListAdapter(List<ExpandInfo> data) {
        super(R.layout.main_expand_item, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, ExpandInfo function) {
        baseViewHolder.setText(R.id.tv_expand_name, function.getRemark());
        EditText editText = baseViewHolder.getView(R.id.ed_expand_edit);
        Switch btn = baseViewHolder.getView(R.id.switch_expand_boolean);
        TextView tvTime = baseViewHolder.getView(R.id.tv_expand_time);
        if (function.getDataType() == 1) {
            //整形
            btn.setVisibility(View.GONE);
            tvTime.setVisibility(View.GONE);
            editText.setVisibility(View.VISIBLE);

            editText.setInputType(EditorInfo.TYPE_CLASS_NUMBER | EditorInfo.TYPE_NUMBER_VARIATION_NORMAL);
            editText.setText(function.getValueInt() + "");
        } else if (function.getDataType() == 2) {
            //字符
            btn.setVisibility(View.GONE);
            tvTime.setVisibility(View.GONE);
            editText.setVisibility(View.VISIBLE);

            editText.setInputType(EditorInfo.TYPE_CLASS_TEXT | EditorInfo.TYPE_TEXT_VARIATION_NORMAL);
            editText.setText(function.getValueChar());
        } else if (function.getDataType() == 3) {
            //布爾
            editText.setVisibility(View.GONE);
            tvTime.setVisibility(View.GONE);
            btn.setVisibility(View.VISIBLE);

            btn.setChecked(function.getValueInt() == 0);
            btn.setOnCheckedChangeListener((buttonView, isChecked) -> {
                function.setValueInt(isChecked ? 0 : 1);
            });
        } else if (function.getDataType() == 4) {
            //日期
            editText.setVisibility(View.GONE);
            btn.setVisibility(View.GONE);
            tvTime.setVisibility(View.VISIBLE);
            Calendar calendar = Calendar.getInstance();
            if (function.getValueDatetime() != null) {
                try {
                    calendar.setTime(DateFormat.getDateTimeInstance().parse(function.getValueDatetime()));
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                tvTime.setText(TimeUtils.getStringByFormat(calendar.getTime(), TimeUtils.DATE_FORMAT_DATE));
                //Sep 11, 2020 6:10:42 PM
                tvTime.setOnClickListener(v -> {
                    //时间选择器
                    new TimePickerBuilder(getContext(), (date, view) -> {
                        tvTime.setText(TimeUtils.parseDateToString(date, TimeUtils.DATE_FORMAT_DATE));
                    })
                            .setDate(calendar)
                            .setType(new boolean[]{true, true, true, false, false, false})
                            .setContentTextSize(24)
                            .setLabel("", "", "", "", "", "")
                            .build()
                            .show();

                });
            }
        } else {
            btn.setVisibility(View.GONE);
            tvTime.setVisibility(View.GONE);
            editText.setVisibility(View.GONE);
        }
        if (editText.getVisibility() == View.VISIBLE) {
            editText.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {

                }

                @Override
                public void afterTextChanged(Editable s) {
                    ExpandInfo expandInfo = getData().get(baseViewHolder.getAdapterPosition());
                    if (expandInfo.getDataType() == 1) {
                        if (TextUtil.isNotEmptyOrNullOrUndefined(s.toString())) {
                            expandInfo.setValueInt(Integer.parseInt(s.toString()));
                        }
                    } else if (expandInfo.getDataType() == 2) {
                        if (TextUtil.isNotEmptyOrNullOrUndefined(s.toString())) {
                            expandInfo.setValueChar(s.toString());
                        }
                    }
                }
            });
        }
    }
}
