package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodMenuEditBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author admin
 */
public  abstract class FoodMenuItemProvider extends BaseItemProvider<FoodMenuEditBean> {

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, FoodMenuEditBean foodMenuEditBean) {
        //是否顯示必選
        baseViewHolder.setGone(R.id.tv_food_menu_required, !foodMenuEditBean.isRequired());
        //設置標題
        if(TextUtil.isNotEmptyOrNullOrUndefined(foodMenuEditBean.getShowTitle())){
            baseViewHolder.setText(R.id.tv_food_menu_title, foodMenuEditBean.getShowTitle());
        }
    }
}
