package com.gingersoft.gsa.cloud.main.mvp.ui.fragment;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.gingersoft.gsa.cloud.common.webview.WebviewHelper;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerReportListComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.ReportListContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.ReportListItem;
import com.gingersoft.gsa.cloud.main.mvp.presenter.ReportListPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.ReportListAdapter;
import com.gingersoft.gsa.cloud.ui.adapter.TabFragmentAdapter;
import com.google.android.material.tabs.TabLayout;
import com.gyf.immersionbar.ImmersionBar;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/27/2021 12:07
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class ReportListFragment extends BaseFragment<ReportListPresenter> implements ReportListContract.View {

//    @BindView(R2.id.topBar)
//    QMUITopBar topBar;
//    @BindView(R2.id.recycler_report)
//    RecyclerView recyclerReport;
//
//    private ReportListAdapter mReportListAdapter;

    @BindView(R2.id.topbar)
    QMUITopBar mTopBar;
    @BindView(R2.id.table_layout)
    TabLayout mTabLayout;
    @BindView(R2.id.report_viewpager)
    ViewPager mViewPager;

    private TabFragmentAdapter mTabFragmentAdapter;
    private List<String> titles;

    public static ReportListFragment newInstance() {
        ReportListFragment fragment = new ReportListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerReportListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_report_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        mTopBar.setBackgroundColor(ContextCompat.getColor(mContext, R.color.theme_color));
        mTopBar.setTitle("報表");

        initTitlte();
        initViewPager();
//        topBar.setBackgroundColor(ContextCompat.getColor(mContext, R.color.theme_color));
//        topBar.addLeftBackImageButton().setVisibility(View.GONE);
//        topBar.setTitle("报表");
//
//        Drawable drawable = getResources().getDrawable(R.drawable.ic_line);
//        drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
//
//        List<ReportListItem> reportListItems = new ArrayList<>(5);
//        reportListItems.add(new ReportListItem(drawable,"食品销售排行","https://wyn.ricepon.com/reports/view/eea52d08-cad6-4afe-bb09-2e8349b81f5f?display=pageless&size=fitwidth&parampanel=top&dp=%7B%22userId%22%3A%5B%22340%22%5D%2C%22%E5%B7%B2%E6%9C%89%E5%93%81%E7%89%8C%22%3A%5B%22-1%22%5D%2C%22%E5%B7%B2%E6%9C%89%E9%A4%90%E5%BB%B3%22%3A%5B%22-1%22%5D%2C%22%E5%93%81%E7%89%8C%22%3A%5B%221%22%5D%2C%22%E9%A4%90%E5%BB%B3%22%3A%5B%2226%22%5D%2C%22%E6%8E%92%E5%BA%8F%E9%A1%9E%E5%9E%8B%22%3A%5B%221%22%5D%2C%22%E9%96%8B%E5%A7%8B%E6%97%A5%E6%9C%9F%22%3A%5B%222021-01-31T16%3A00%3A00.000Z%22%5D%2C%22%E7%B5%90%E6%9D%9F%E6%97%A5%E6%9C%9F%22%3A%5B%222021-03-23T16%3A00%3A00.000Z%22%5D%7D&theme=default&lng=zh-TW&token=5c80dba856cd9ef65b55aa487571d101ef11bdbd1256de11b862845a99ca8d01"));
//        reportListItems.add(new ReportListItem(drawable,"营业报表","https://wyn.ricepon.com/reports/view/eea52d08-cad6-4afe-bb09-2e8349b81f5f?display=pageless&size=fitwidth&parampanel=top&dp=%7B%22userId%22%3A%5B%22340%22%5D%2C%22%E5%B7%B2%E6%9C%89%E5%93%81%E7%89%8C%22%3A%5B%22-1%22%5D%2C%22%E5%B7%B2%E6%9C%89%E9%A4%90%E5%BB%B3%22%3A%5B%22-1%22%5D%2C%22%E5%93%81%E7%89%8C%22%3A%5B%221%22%5D%2C%22%E9%A4%90%E5%BB%B3%22%3A%5B%2226%22%5D%2C%22%E6%8E%92%E5%BA%8F%E9%A1%9E%E5%9E%8B%22%3A%5B%221%22%5D%2C%22%E9%96%8B%E5%A7%8B%E6%97%A5%E6%9C%9F%22%3A%5B%222021-01-31T16%3A00%3A00.000Z%22%5D%2C%22%E7%B5%90%E6%9D%9F%E6%97%A5%E6%9C%9F%22%3A%5B%222021-03-23T16%3A00%3A00.000Z%22%5D%7D&theme=default&lng=zh-TW&token=5c80dba856cd9ef65b55aa487571d101ef11bdbd1256de11b862845a99ca8d01"));
//        reportListItems.add(new ReportListItem(drawable,"订单报表","https://wyn.ricepon.com/reports/view/eea52d08-cad6-4afe-bb09-2e8349b81f5f?display=pageless&size=fitwidth&parampanel=top&dp=%7B%22userId%22%3A%5B%22340%22%5D%2C%22%E5%B7%B2%E6%9C%89%E5%93%81%E7%89%8C%22%3A%5B%22-1%22%5D%2C%22%E5%B7%B2%E6%9C%89%E9%A4%90%E5%BB%B3%22%3A%5B%22-1%22%5D%2C%22%E5%93%81%E7%89%8C%22%3A%5B%221%22%5D%2C%22%E9%A4%90%E5%BB%B3%22%3A%5B%2226%22%5D%2C%22%E6%8E%92%E5%BA%8F%E9%A1%9E%E5%9E%8B%22%3A%5B%221%22%5D%2C%22%E9%96%8B%E5%A7%8B%E6%97%A5%E6%9C%9F%22%3A%5B%222021-01-31T16%3A00%3A00.000Z%22%5D%2C%22%E7%B5%90%E6%9D%9F%E6%97%A5%E6%9C%9F%22%3A%5B%222021-03-23T16%3A00%3A00.000Z%22%5D%7D&theme=default&lng=zh-TW&token=5c80dba856cd9ef65b55aa487571d101ef11bdbd1256de11b862845a99ca8d01"));
//
//        mReportListAdapter = new ReportListAdapter(reportListItems);
//        recyclerReport.setAdapter(mReportListAdapter);
//        mReportListAdapter.setOnItemClickListener(new OnItemClickListener() {
//            @Override
//            public void onItemClick(@NonNull BaseQuickAdapter<?, ?> adapter, @NonNull View view, int position) {
//                WebviewHelper.openUrl(reportListItems.get(position).getReportUrl());
//            }
//        });
    }

    /**
     * 设置顶部数据
     */
    private void initTitlte() {
        titles = new ArrayList<>();
        titles.add("營業分析");
        titles.add("銷售分析");
        titles.add("支付分析");

        BusinessReportFragment businessReportFragment = BusinessReportFragment.newInstance();

        List<Fragment> mFragments = new ArrayList<>();
        mFragments.add(businessReportFragment);
        mFragments.add(SalesFragment.newInstance());
        mFragments.add(PaymentMethodReportFragment.newInstance());
        //实例化适配器
        mTabFragmentAdapter = new TabFragmentAdapter(getChildFragmentManager(), 1);
        //设置加载的Fragment集合
        mTabFragmentAdapter.setFragments(mFragments);
    }

    /**
     * 设置Viewpager的适配器
     */
    private void initViewPager() {
        //设置Viewpager的适配器
        mViewPager.setAdapter(mTabFragmentAdapter);
        mTabLayout.setupWithViewPager(mViewPager);//TabLayout绑定ViewPager
        mTabLayout.setTabsFromPagerAdapter(mTabFragmentAdapter);//TabLayout的标签从Adapter中获取
        //用来循环适配器中的视图总数
        for (int i = 0; i < mTabFragmentAdapter.getCount(); i++) {
            //获取每一个tab对象
            TabLayout.Tab tabAt = mTabLayout.getTabAt(i);
            if (tabAt != null) {
                //将每一个条目设置我们自定义的视图
                tabAt.setCustomView(R.layout.layout_table_item);
                //默认选中第一个
                if (i == 0) {
                    // 设置第一个tab的TextView是被选择的样式
                    setSelectTab(tabAt, true);
                }
                //通过tab对象找到自定义视图的ID
                TextView textView = tabAt.getCustomView().findViewById(R.id.tv_tab);
                textView.setText(titles.get(i));//设置tab上的文字
            }
        }

        mTabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                setSelectTab(tab, true);
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {
                setSelectTab(tab, false);
            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });
    }

    private void setSelectTab(TabLayout.Tab tabAt, boolean isSelected) {
        if (tabAt.getCustomView() != null) {
            TextView tab = tabAt.getCustomView().findViewById(R.id.tv_tab);//第一个tab被选中
            tab.setSelected(isSelected);
            //设置选中标签的文字大小
            tab.setTextSize(TypedValue.COMPLEX_UNIT_PX, isSelected ? getResources().getDimensionPixelSize(R.dimen.sp_16) : getResources().getDimensionPixelSize(R.dimen.sp_14));
            tab.getPaint().setFakeBoldText(isSelected);
        }
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        _mActivity.finish();
    }

}
