package com.joe.print.mvp.presenter;

import android.app.Application;
import android.content.Context;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.joe.print.mvp.print.printerManger.PrinterManager;
import com.gingersoft.gsa.cloud.common.utils.JsonUtils;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.database.bean.PrinterListBean;
import com.gingersoft.gsa.cloud.database.utils.PrintCurrencyDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.PrinterDeviceDaoUtils;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;
import com.joe.print.mvp.contract.PrintContract;

import java.util.List;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/18/2020 14:57
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class PrintPresenter extends BasePresenter<PrintContract.Model, PrintContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    //通用配置
    private PrintCurrencyBean printCurrencyBean;
    //默認打印機
    private PrinterDeviceBean printerDeviceBean;

    @Inject
    public PrintPresenter(PrintContract.Model model, PrintContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    /**
     * 獲取打印機列表
     *
     * @param restaurantId 餐廳id
     */
    public void getPrinterList(int restaurantId) {
        mModel.getPrinterList(restaurantId)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult.isSuccess()) {
                            PrinterListBean deviceBeans = JsonUtils.parseObject(baseResult.getData(), PrinterListBean.class);
                            if (deviceBeans != null) {
                                //有打印機，返回true
                                PrinterManager.getPrinterManager().setDeviceBeans(deviceBeans.getList());
                                mRootView.showPrinterList(deviceBeans.getList());
                            } else {
                                mRootView.showPrinterList(null);
                            }
                        } else {
                            mRootView.showPrinterList(null);
                        }
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mRootView.showPrinterList(null);
                    }
                });
    }

    public List<PrinterDeviceBean> getAllPrintList(Context context) {
        PrinterDeviceDaoUtils printerDeviceDaoUtils = new PrinterDeviceDaoUtils(context);
        return printerDeviceDaoUtils.queryAllPrinterDeviceBean();
    }

    /**
     * 通過類型獲取打印通用配置
     *
     * @param context
     * @param type    1：堂食，2：外送
     * @return
     */
    public PrintCurrencyBean getPrintCurrencyBeanByType(Context context, int type) {
        PrintCurrencyDaoUtils printCurrencyDaoUtils = new PrintCurrencyDaoUtils(context);
        List<PrintCurrencyBean> printCurrencyBeans = printCurrencyDaoUtils.queryAllPrintCurrencyBean();
        for (PrintCurrencyBean printCurrencyBean : printCurrencyBeans) {
            if (printCurrencyBean.getType() == type) {
                return printCurrencyBean;
            }
        }
        return null;
    }


    public PrinterDeviceBean getDefaultPrintInList(List<PrinterDeviceBean> printerDeviceBeans, String printDeviceName) {
        if (printerDeviceBeans != null) {
            for (PrinterDeviceBean printerDeviceBean : printerDeviceBeans) {
                if (printerDeviceBean.getPrinterDeviceDefaultId() != null) {
                    //默認打印機
                    this.printerDeviceBean = printerDeviceBean;
                    return this.printerDeviceBean;
                }
            }
            //沒有設置默認打印機，取用戶最近使用的打印機
            for (PrinterDeviceBean printerDeviceBean : printerDeviceBeans) {
                if (printDeviceName != null && printDeviceName.equals(printerDeviceBean.getName())) {
                    this.printerDeviceBean = printerDeviceBean;
                    return this.printerDeviceBean;
                }
            }
            //沒有設置默認打印機，也沒有最近使用的打印機，並且如果打印機數量為1，就取這一台
            if (printerDeviceBeans.size() == 1) {
                return printerDeviceBeans.get(0);
            }
        }
        return printerDeviceBean;
    }
    public PrinterDeviceBean getPrinterDeviceBeanByName(List<PrinterDeviceBean> printerDeviceBeans, String printDeviceName) {
        for (PrinterDeviceBean printerDeviceBean : printerDeviceBeans) {
            if (printDeviceName != null && printDeviceName.equals(printerDeviceBean.getName())) {
                this.printerDeviceBean = printerDeviceBean;
                return this.printerDeviceBean;
            }
        }
        return null;
    }
}
