package com.joe.print.mvp.ui.adapter;

import android.graphics.Typeface;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.print.bean.PrjBean;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by Wyh on 2020/2/20.
 */
public class KitChenPrjPrintFoodAdapter extends BaseQuickAdapter<PrjBean, BaseViewHolder> {

    private int indentation = 0;

    private int foodFontSize = 24;
    private int modifierFontSize = 24;
    private int foodIsBold;
    private int modifierIsBold;
    private int foodIsItalic;
    private int modifierIsItalic;
    private String[] languageTypes;

    public KitChenPrjPrintFoodAdapter(@Nullable List<PrjBean> data, PrinterDeviceBean printerDeviceBean) {
        super(R.layout.print_kitchen_item_parent, data);
        try {
            this.foodFontSize = Integer.parseInt(printerDeviceBean.getFoodFont()) * 2;
            this.modifierFontSize = Integer.parseInt(printerDeviceBean.getModifierFont()) * 2;
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.foodIsBold = printerDeviceBean.getFoodIsBold();
        this.modifierIsBold = printerDeviceBean.getModifierIsBold();
        this.foodIsItalic = printerDeviceBean.getFoodIsItalic();
        this.modifierIsItalic = printerDeviceBean.getModifierIsItalic();
        languageTypes = printerDeviceBean.getLanguageType().split(",");
    }

    @Override
    protected void convert(BaseViewHolder helper, PrjBean item) {
        LinearLayout layout = helper.getView(R.id.layout_print_kitchen_parent);
        for (String type : languageTypes) {
            String languageType = type;
            if (languageType.contains(".")) {
                languageType = type.substring(0, type.indexOf("."));
            }
            if (languageType.equals(PrinterDeviceBean.LANGUAGE_TWO)) {
                //語言二
                if (TextUtil.isNotEmptyOrNullOrUndefined(item.getProductName2())) {
                    layout.addView(getOtherLanguageView(helper.getAdapterPosition(), item.getItemType(), item.getProductName2(), item.getNumber()));
                }
            } else if (languageType.equals(PrinterDeviceBean.LANGUAGE_THREE)) {
                //語言三
                if (TextUtil.isNotEmptyOrNullOrUndefined(item.getProductName3())) {
                    layout.addView(getOtherLanguageView(helper.getAdapterPosition(), item.getItemType(), item.getProductName3(), item.getNumber()));
                }
            } else {
                //語言一或其他
                if (TextUtil.isNotEmptyOrNullOrUndefined(item.getProductName())) {
                    layout.addView(getOtherLanguageView(helper.getAdapterPosition(), item.getItemType(), item.getProductName(), item.getNumber()));
                }
            }
        }
    }

    private View getOtherLanguageView(int adapterPosition, int itemType, String foodName, int foodNumber) {
        View view = View.inflate(getContext(), R.layout.print_kitchen_item_food, null);
        TextView tvFoodName = view.findViewById(R.id.tv_food_name);
        TextView tvFoodNum = view.findViewById(R.id.tv_food_number);
        if (adapterPosition == 0) {
            //只第一次測量一下
            indentation = new BigDecimal(tvFoodName.getPaint().measureText("哈")).setScale(0, BigDecimal.ROUND_HALF_UP).intValue();
        }

        boolean isBold, isItalic;

        int paddingLeft;
        if (itemType == 2) {
            //細項，縮進
            paddingLeft = indentation;
            tvFoodName.setTextSize(modifierFontSize);
            tvFoodNum.setTextSize(modifierFontSize);

            isBold = modifierIsBold == 1;
            isItalic = modifierIsItalic == 1;
        } else if (itemType == 3) {
            //細項，縮進
            paddingLeft = indentation * 2;
            tvFoodName.setTextSize(modifierFontSize);
            tvFoodNum.setTextSize(modifierFontSize);

            isBold = modifierIsBold == 1;
            isItalic = modifierIsItalic == 1;
        } else {
            paddingLeft = 0;
            tvFoodName.setTextSize(foodFontSize);
            tvFoodNum.setTextSize(foodFontSize);

            isBold = foodIsBold == 1;
            isItalic = foodIsItalic == 1;
        }
        tvFoodName.setPadding(paddingLeft, tvFoodName.getPaddingTop(), tvFoodName.getPaddingRight(), tvFoodName.getPaddingBottom());
        tvFoodNum.setText(String.valueOf(foodNumber));
        tvFoodName.setText(foodName);

        if (isBold && isItalic) {
            tvFoodName.setTypeface(null, Typeface.BOLD_ITALIC);
            tvFoodNum.setTypeface(null, Typeface.BOLD_ITALIC);
        } else if (isBold) {
            tvFoodName.setTypeface(null, Typeface.BOLD);
            tvFoodNum.setTypeface(null, Typeface.BOLD);
        } else if (isItalic) {
            tvFoodName.setTypeface(null, Typeface.ITALIC);
            tvFoodNum.setTypeface(null, Typeface.ITALIC);
        } else {
            tvFoodName.setTypeface(null, Typeface.NORMAL);
            tvFoodNum.setTypeface(null, Typeface.NORMAL);
        }
        return view;
    }
}
