package com.joe.print.mvp.ui.adapter;

import android.content.Context;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.joe.print.R;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * 打印進度
 */
public class PrintProgressAdapter extends BaseQuickAdapter<String, BaseViewHolder> {

    private int completeColor;
    private int inProgressColor;

    public PrintProgressAdapter(Context context, @Nullable List<String> data) {
        super(R.layout.print_progress_item, data);
        completeColor = ContextCompat.getColor(context, R.color.order_state0_color);
        inProgressColor = ContextCompat.getColor(context, R.color.theme_333_color);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, String s) {
        baseViewHolder.setText(R.id.tv_print_progressbar, s);
        if (baseViewHolder.getAdapterPosition() == getItemCount() - 1) {
            baseViewHolder.setGone(R.id.pb_print_progressbar, true);
            baseViewHolder.setTextColor(R.id.tv_print_progressbar, completeColor);
            baseViewHolder.setGone(R.id.iv_checked, false);
        } else {
            baseViewHolder.setGone(R.id.pb_print_progressbar, false);
            baseViewHolder.setTextColor(R.id.tv_print_progressbar, inProgressColor);
            baseViewHolder.setGone(R.id.iv_checked, true);
        }
    }
}
