package com.joe.print.mvp.ui.view;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;
import com.joe.print.R;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/30
 * Time: 11:00
 * Use:
 */
public class BillItemView extends LinearLayout {

    private List<PrintBillItem> data;

    public BillItemView(Context context, List<PrintBillItem> data) {
        super(context);
        this.data = data;
        setOrientation(LinearLayout.VERTICAL);
        init();
    }

    private void init() {
        for (PrintBillItem item : data) {
            View view = View.inflate(getContext(), R.layout.print_bill_adapter_item_bill, null);
            TextView billNam = view.findViewById(R.id.print_bill_name);
            TextView billValue = view.findViewById(R.id.print_bill_value);
            billNam.setText(item.getBillName());
            billValue.setText(item.getBillAmount());
            addView(view);
        }
    }
}
