package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.WarehouseDetailsModule;
import com.gingersoft.supply_chain.mvp.contract.WarehouseDetailsContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.WarehouseDetailsFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/21/2021 10:15
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = WarehouseDetailsModule.class, dependencies = AppComponent.class)
public interface WarehouseDetailsComponent {
    void inject(WarehouseDetailsFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        WarehouseDetailsComponent.Builder view(WarehouseDetailsContract.View view);

        WarehouseDetailsComponent.Builder appComponent(AppComponent appComponent);

        WarehouseDetailsComponent build();
    }
}