package com.gingersoft.supply_chain.mvp.bean;

import com.gingersoft.gsa.cloud.common.constans.AppConstant;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/17
 * Time: 11:36
 * Use:
 */
@Data
public class ConfirmOrderBean {
    private PurchaseOrder purchaseOrder;
    private List<PurchaseOrderDetails> purchaseOrderDetails;
    private double minimumAmount;//最低採購金額

    @Data
    public static class PurchaseOrder implements Serializable {
        private static final long serialVersionUID = -8777410033061311699L;
        private int id;
        private int supplierId;
        private String supplierName;
        private int brandId;
        private int restaurantId;
        private String sendingAddress;
        //默認第二天
        private String initialShippingTime;
        private double totalAmount;
        /**
         * 運費
         */
        private double shipping;
        /**
         * 實際支付金額
         */
        private double actualPayment;
        /**
         * 備註
         */
        private String remarks;
    }

    public static PurchaseOrder conversionPurchaseOrder(ShoppingCartBean shoppingCartBean, double totalAmount) {
        PurchaseOrder purchaseOrder = new PurchaseOrder();
        purchaseOrder.setSupplierId(shoppingCartBean.getSupplierId());
        purchaseOrder.setSupplierName(shoppingCartBean.getSupplierName());
        purchaseOrder.setBrandId(AppConstant.getBrandId());
        purchaseOrder.setRestaurantId(AppConstant.getRestaurantId());
        purchaseOrder.setRemarks(shoppingCartBean.getRemarks());
        purchaseOrder.setInitialShippingTime(shoppingCartBean.getInitialShippingTime());
        purchaseOrder.setShipping(shoppingCartBean.getShipping());
        purchaseOrder.setTotalAmount(totalAmount);
        purchaseOrder.setActualPayment(MoneyUtil.sum(totalAmount, shoppingCartBean.getShipping()));
        return purchaseOrder;
    }

    @Data
    public static class PurchaseOrderDetails {
        private int purchaseFoodId;
        private int foodQuantity;
        private double foodPrice;
        private int orderId;
    }

    public static PurchaseOrderDetails conversionPurchaseOrderDetails(PurchaseFoodBean cartFood) {
        PurchaseOrderDetails purchaseOrderDetails = new PurchaseOrderDetails();
        purchaseOrderDetails.setPurchaseFoodId(cartFood.getId());
        purchaseOrderDetails.setFoodQuantity(cartFood.getFoodQuantity());
        purchaseOrderDetails.setFoodPrice(cartFood.getUnitPrice());
        return purchaseOrderDetails;
    }


}
