package com.gingersoft.supply_chain.mvp.bean;

import java.io.Serializable;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/29
 * Time: 17:13
 * Use:
 */
@Data
public class DeputyUnitBean implements Serializable {
    private Integer id;
    private int uid;
    /**
     * 品牌id
     */
    private int brandId;
    /**
     * 餐廳id
     */
    private int restaurantId;
    /**
     * 食材id，沒有時傳0
     */
    private Long foodUnitId;
    /**
     * 副單位
     */
    private String deputyUnit;
    /**
     * 副單位的值
     */
    private double deputyValue;
    /**
     * 入庫單位單價
     */
    private double unitPrice;
    /**
     * 食材id
     */
    private int purchaseFoodId;
    /**
     * 換算倍數
     */
    private double conversionMultiple;
    /**
     * 是否删除：0正常，1删除
     */
    private int deletes;
    /**
     * 不知道幹嘛的
     */
    private int type;

    public DeputyUnitBean() {
    }

    public DeputyUnitBean(String deputyUnit, double deputyValue) {
        this.deputyUnit = deputyUnit;
        this.deputyValue = deputyValue;
    }

    public static DeputyUnitBean getDeputyUnitByWareHousingUnit(WareHousingUnitBean wareHousingUnitBean){
        DeputyUnitBean deputyUnitBean = new DeputyUnitBean();
        deputyUnitBean.setId(wareHousingUnitBean.getId());
        deputyUnitBean.setDeputyUnit(wareHousingUnitBean.getUnitName());
        deputyUnitBean.setDeputyValue(wareHousingUnitBean.getUnitValue());
        deputyUnitBean.setConversionMultiple(wareHousingUnitBean.getConversionMultiple());
        deputyUnitBean.setUnitPrice(wareHousingUnitBean.getUnitPrice());
        return deputyUnitBean;
    }

    public static WareHousingUnitBean getWareHousingUnitByDeputyUnit(DeputyUnitBean deputyUnitBean){
        WareHousingUnitBean wareHousingUnitBean = new WareHousingUnitBean();
        wareHousingUnitBean.setUnitName(deputyUnitBean.getDeputyUnit());
        wareHousingUnitBean.setUnitValue(deputyUnitBean.getDeputyValue());
        wareHousingUnitBean.setConversionMultiple(deputyUnitBean.getConversionMultiple());
        wareHousingUnitBean.setUnitPrice(deputyUnitBean.getUnitPrice());
        return wareHousingUnitBean;
    }
}
