package com.gingersoft.supply_chain.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.ui.bean.view.CategoryBean;
import com.gingersoft.supply_chain.mvp.bean.BuyIngredientsBean;
import com.gingersoft.supply_chain.mvp.bean.FoodByCategoryResultBean;
import com.gingersoft.supply_chain.mvp.bean.FoodListInfoBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.jess.arms.mvp.IView;
import com.jess.arms.mvp.IModel;
import com.qmuiteam.qmui.widget.section.QMUISection;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/10/2021 14:55
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface BuyIngredientsContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        /**
         * 加載分類
         *
         * @param foodCategoryTrees 所有分類層級信息
         */
        void initCategoryInfo(List<OrderCategoryBean.FoodCategoryTrees> foodCategoryTrees);

        /**
         * 加載失敗
         */
        void loadFail();

        /**
         * 結束加載並且沒有更多數據了
         */
        void finishLoad(boolean noData);

        /**
         * 加載食品
         *
         * @param buyIngredientsBeans 顯示的食材
         * @param addToHead           是否添加到頭部
         * @param isReset             是否重新設置數據
         */
        void loadFood(List<BuyIngredientsBean> buyIngredientsBeans, boolean addToHead, boolean isReset);

        void selectFirstCategoryByIndex(int position);

        /**
         * 食材列表滾動到指定位置
         *
         * @param index 指定位置
         */
        void scrollToPosition(int index);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<FoodListInfoBean> getFoodIngredientsData(Map<String, Object> map);

        Observable<BaseResult> getFoodBySupplierId(Map<String, Object> map);

        Observable<BaseResult> deleteFood(int foodId);

        Observable<OrderCategoryBean> getCategoryTrees(Map<String, Object> map);

        Observable<FoodByCategoryResultBean> getFoodByCategory(Map<String, Object> map);
    }
}
