package com.gingersoft.supply_chain.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.BuyIngredientsBean;
import com.gingersoft.supply_chain.mvp.bean.DishDetailResultBean;
import com.gingersoft.supply_chain.mvp.bean.DishesResultBean;
import com.gingersoft.supply_chain.mvp.ui.adapter.dishes.DishNode;
import com.gingersoft.supply_chain.mvp.ui.adapter.dishes.DishesGroupNode;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;

/**
 *
 */
public interface DishesContract {
    interface View extends IView {
        /**
         * 加載菜品組數據
         */
        void loadDishGroupInfo( List<DishesGroupNode> dishGroup);
         /* 查询菜品食材信息*/
        void loadDishesInfo(DishNode dishNode, DishDetailResultBean dishesDetail);

        /**
         * 加載失敗
         */
        void loadDishGroupFail();

        void loadDishesFail();

        /**
         * 加載/修改菜品食材信息
         *
         * @param buyIngredientsBeans 顯示的食材
         */
        void loadFood(List<BuyIngredientsBean> buyIngredientsBeans);

        void selectDishGroupByIndex(int position);

    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<DishesResultBean> getDishGroupData(Map<String, Object> map);

        Observable<DishDetailResultBean> getDishesDetailData(Map<String, Object> map);

        Observable<BaseResult> bindDishes(RequestBody requestBody);

    }
}