package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.view.View;
import android.widget.TextView;

import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 15:41
 * Use:
 */
public class FoodCategoryAdapter extends BaseQuickAdapter<OrderCategoryBean.FoodCategoryTrees, BaseViewHolder> {

    private int selectIndex = 0;
    private int checkedBg = -1;
    private int unCheckedBg = -1;

    private int checkedTextColor;
    private int unCheckedTextColor;
    private boolean showDelete = false;

    public FoodCategoryAdapter(int layoutId, @Nullable List<OrderCategoryBean.FoodCategoryTrees> data) {
        super(layoutId, data);
        addChildClickViewIds(R.id.iv_category_delete);
    }

    public FoodCategoryAdapter(@Nullable List<OrderCategoryBean.FoodCategoryTrees> data) {
        super(R.layout.item_second_category, data);
        addChildClickViewIds(R.id.iv_category_delete);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, OrderCategoryBean.FoodCategoryTrees categoryBean) {
        viewHolder.setText(R.id.tv_second_category_title, categoryBean.getName());
        TextView tvName = viewHolder.getView(R.id.tv_second_category_title);
        CardView cardView = viewHolder.getView(R.id.card_purchase_category);
        if (categoryBean.getId() == -1) {
            cardView.setVisibility(View.GONE);
            return;
        } else {
            cardView.setVisibility(View.VISIBLE);
        }
        viewHolder.setVisible(R.id.tv_second_category_title, TextUtil.isNotEmptyOrNullOrUndefined(categoryBean.getName()));
        if (viewHolder.getAdapterPosition() == selectIndex) {
            if (checkedBg != -1) {
                cardView.setBackground(ContextCompat.getDrawable(getContext(), checkedBg));
            }
            if (checkedTextColor != 0) {
                tvName.setTextColor(checkedTextColor);
            }
        } else {
            if (unCheckedBg != -1) {
                cardView.setBackground(ContextCompat.getDrawable(getContext(), unCheckedBg));

            }
            if (unCheckedTextColor != 0) {
                tvName.setTextColor(unCheckedTextColor);
            }
        }
    }

    public void setShowDelete(boolean showDelete) {
        this.showDelete = showDelete;
        notifyDataSetChanged();
    }

    public FoodCategoryAdapter setCheckedBg(int checkedBg) {
        this.checkedBg = checkedBg;
        return this;
    }

    public FoodCategoryAdapter setUnCheckedBg(int unCheckedBg) {
        this.unCheckedBg = unCheckedBg;
        return this;
    }

    public FoodCategoryAdapter setSelectIndex(int selectIndex) {
        int lastIndex = this.selectIndex;
        this.selectIndex = selectIndex;
        if (lastIndex >= 0 && lastIndex < getItemCount()) {
            notifyItemChanged(lastIndex);
        }
        if (this.selectIndex >= 0 && this.selectIndex < getItemCount()) {
            notifyItemChanged(this.selectIndex);
        }
        return this;
    }

    public FoodCategoryAdapter setCheckedTextColor(int checkedTextColor) {
        this.checkedTextColor = checkedTextColor;
        return this;
    }

    public FoodCategoryAdapter setUnCheckedTextColor(int unCheckedTextColor) {
        this.unCheckedTextColor = unCheckedTextColor;
        return this;
    }

    public int getSelectIndex() {
        return selectIndex;
    }

}
